package org.cocome.tradingsystem.systests.scenarios;

import org.cocome.tradingsystem.systests.interfaces.IOrder;
import org.cocome.tradingsystem.systests.util.GeneratedStockItem;

/**
 * This test covers use cases 3 and 5. An order will be executed for some
 * products and the roll in of the correct products will be handled.
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Revision: 1.1 $
 * @lev.rating GREEN Rev: 64
 */

public class OrderAndReceiveProductsTest extends TestScenarioBase {

	/** Execute the test case. */
	public void testScenario() throws Exception {
		StoreWrapper store = stores.get(0);

		/***********************************************************************
		 * use case 3 - order products
		 **********************************************************************/

		// manager selects a product which runs out of stock
		GeneratedStockItem item = store.getItemLowOnStock();

		// create a new order for this product
		IOrder order = store.getStorePC().createOrder();
		int orderAmount = item.getMaxAmount() - item.getAmount();
		order.addOrderItem(item.getProduct().getProduct(), orderAmount);

		// execute the order
		store.getStorePC().executeOrder(order);

		/***********************************************************************
		 * use case 4 - receive order products
		 **********************************************************************/

		// products arrive with attached orderId
		// Using orderId StockManager can get all information about the order
		// StoreManager checks if everything is correct
		// Assumption: Everything correct, so roll in order
		store.getStorePC().rollInOrder(order);

		// check if product amount is increased as expected
		assertEquals(
				"Amount of original order and retreived order should be equal",
				item.getMaxAmount(), store.getStorePC().getAmount(
						item.getProduct().getProduct()));

	}

}
