package org.cocome.tradingsystem.systests.scenarios;

import java.util.concurrent.TimeoutException;

/**
 * This test covers use case 2 (ManageExpressCheckout). The system is put to
 * express mode, afterwards express mode lights must be switched on and credit
 * card payment is disabled.
 * <p>
 * This test checks that credit card payment is not possible anymore.
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Revision: 1.1 $
 * @lev.rating GREEN Rev: 64
 */

public class ManageExpressCheckoutTest extends ManageExpressCheckoutBase {

	/** {@inheritDoc} */
	@Override
	public void testScenario() throws Exception {

		initializeCashDesk(0, 0);

		putCashDeskInExpressMode();

		checkNotificationOfExpressMode();

		checkExpressModeLightsOn();

		tryDeactivatedCreditCardPayment();

		// 5. The system sets maximum of items per sale to 8
		// --> no check implementet so far,
		// not defined what's the system corret reaction

	}

	/** Executes actions to confirm credit card payment is inactive */
	private void tryDeactivatedCreditCardPayment() throws Exception,
			TimeoutException {
		// 4. The system deactivates the possibility for paying
		// by credit card

		// first do a new sale
		startNewSale(1);
		enterProducts(1);
		finishSale();

		// try payment by card - exception to use case
		cashBox.startCreditCardPayment();

		// message should be displayed
		cashDesk.getUserDisplay().waitForUpdate(500);
		assertTrue(
				"Message 'payment by credit card not possible' should be shown",
				cashDesk.getUserDisplay()
						.isMessageForCreditCardNotPossibleShown());
	}

}
