package org.cocome.tradingsystem.systests.scenarios;

/**
 * This is an abstract base class for specifiying test scenarios which should be
 * executed in the express sales mode. It provides methods for putting the
 * system to express mode and verify express mode.
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 64 $
 * @levd.rating GREEN Rev: 64
 */
public abstract class ManageExpressCheckoutBase extends ProcessSaleBase {

	/** The maximum number of items allowed in an express sale. */
	public static int MAXIMUM_ITEMS_AT_EXPRESS_SALE = 8;

	/**
	 * Executes the test scenario.
	 * 
	 * @throws Exception
	 */
	public abstract void testScenario() throws Exception;

	/**
	 * Executes some express sales to put cash desk in express mode.
	 */
	protected void putCashDeskInExpressMode() throws Exception {

		// 1. The system records a certain amount of express sales
		// (since the are executed in a row timing shouldn't worth considering)
		for (int s = 0; s < cashDesk
				.getNumberOfExpressSalesForExpressModeSwitch(); s++) {
			performExpressSale();
		}
	}

	/**
	 * Executes actions to check notification of express mode.
	 */
	protected void checkNotificationOfExpressMode() throws Exception {
		// 2. The system notifies the cashier, that it will swith to express
		// mode
		cashDesk.getUserDisplay().waitForUpdate(500);
		assertTrue("Message for express mode should be shown.", cashDesk
				.getUserDisplay().isMessageForExpressModeShown());
	}

	/**
	 * Executes actions to check the Lights display is switched on correctly.
	 */
	protected void checkExpressModeLightsOn() throws Exception {
		// 3. The system switches the cash desks express light and no credit
		// card light on
		cashDesk.getLightsDisplay().waitForUpdate(500);
		assertTrue("Express light should be on.", cashDesk.getLightsDisplay()
				.isExpressModeLightOn());
		assertTrue("'No credit card' light should be on.", cashDesk
				.getLightsDisplay().isNoCreditCardLightOn());
	}

	/**
	 * The methods performs a single sale with the maximum possible number of
	 * items for a express sale.
	 */
	private void performExpressSale() throws Exception {

		// The cashier starts new sale by pressing a button at the cash
		// box.
		startNewSale(MAXIMUM_ITEMS_AT_EXPRESS_SALE);

		// Purchase goods
		enterProducts(MAXIMUM_ITEMS_AT_EXPRESS_SALE);

		// The cashier indicates the end of entering items by pressing
		// the SaleFinished-button at the cash box.
		finishSale();

		// customer pays cash
		handleCashPayment();

		// update inventroy, print printout
		updateInventory();
	}
}
