package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface of the display visible to the user displaying product information
 * and the running total. As the exact format of the display output is not
 * specified, there are many methods to dermine the meaning of the display
 * contents. These must be implemented by the glue code (which in turn should
 * know enough about the actual implementation to extract this information).
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface IUserDisplay extends IUpdateReceiver {

	/**
	 * Determines if the display currently shows the apropriate message to
	 * indicate scan of an invalid / unkown barcode; returns false otherwise
	 */
	public boolean isMessageForInvalidBarcodeShown() throws Exception;

	/**
	 * Determines if the display currently shows the expected name of a product,
	 * returns false if not.
	 * 
	 * @param expectedName -
	 *            name of prodouct to be expeted in display
	 */
	public boolean isProductNameShown(String expectedName) throws Exception;

	/**
	 * Determines if the display currently shows the expected price of a
	 * product, returns false if not.
	 * 
	 * @param expectedPrice -
	 *            price of product to be expeted in display
	 */
	public boolean isPriceShown(int expectedPrice) throws Exception;

	/**
	 * Determines if the display currently shows the aporpriate message to
	 * indicate express mode.
	 */
	public boolean isMessageForExpressModeShown() throws Exception;

	/**
	 * Determines if the display currently shows the apropriate message to
	 * indicate payment by credit card is not possible.
	 */
	public boolean isMessageForCreditCardNotPossibleShown() throws Exception;

	/**
	 * Determines if the display currently shows the apropriate message to
	 * indicate payment by credit card was successful.
	 */
	public boolean isMessageForCreditCardPaymentSuccessfulShown()
			throws Exception;

	/**
	 * Determines if the display currently shows the apropriate message to
	 * indicate a failed validation of a credit card.
	 */
	public boolean isMessageForCreditCardValidationFailedShown()
			throws Exception;
}
