package org.cocome.tradingsystem.systests.interfaces;

import java.util.concurrent.TimeoutException;

/**
 * Interface for devices which receive updates from the system. This interface
 * is crucial, as the trading system is asynchronous. So we can not test for a
 * reaction immediately, but rather have to way for some components to update
 * their state. However we limit the time to wait for this update, so we avoid
 * the test to lock up in case of an error and furthermore to test reaction
 * times (if specified).
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface IUpdateReceiver {

	/**
	 * Wait until the device gets updated (e.g., via a message). If no update
	 * occurs during the requested period throw an exception.
	 * 
	 * @param maxMilliseconds
	 *            the maximal number of millisecond to wait for an update.
	 * @throws TimeoutException
	 *             if no update occurred during the specified duration.
	 */
	void waitForUpdate(int maxMilliseconds) throws TimeoutException;
}
