package org.cocome.tradingsystem.systests.interfaces;

/**
 * This is the central interface for the glue code as it is the entry point for
 * all tests. The test driver isolates the system tests from the actual
 * implementation. This way the tests themselves can be kept simple and for
 * testing a different implementation only the test driver needs to be adjusted.
 * <p>
 * The test driver is both used to initialize the entire system as well as a
 * factory for stores and cash desks.
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface ITestDriver {

	/**
	 * This is the first method called before any other method of the test
	 * driver is called. Here the system is started.
	 * 
	 * @return an enterprise object.
	 */
	IEnterprise initializeSystem() throws Exception;

	/**
	 * Releases all ressources and stops the system. No methods on this driver
	 * or any other of the objects created will be called afterwards. You are
	 * guaranteed that this will be called after testing is completed.
	 */
	void shutdownSystem();

	/** Returns a newly created store. */
	IStorePC createStore() throws Exception;

	/**
	 * Returns a newly created cash desk system. If required the test driver has
	 * to create the interfaces for the connected hardware as well.
	 * 
	 * @param store
	 *            the store this cash desk is connected to.
	 */
	ICashDesk createCashDesk(IStorePC store) throws Exception;

	/** Returns the globally unique bank used for all credit card transactions. */
	IBank getBank() throws Exception;
}
