package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface of the store PC. This is the view the environment (and thus the
 * system tests) has on the system. It is mostly used for actions on the
 * inventory (for most implementation these will map to database calls).
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface IStorePC {

	/**
	 * Insert a new item into the stock of this store. The primary use of this
	 * is the initial creation of test data. Additional fields required by the
	 * database should be provided by the test driver.
	 * 
	 * @param product
	 *            the product added to the store.
	 * @param salesPrice
	 *            the price at which the product is sold in the store in Cent.
	 * @param amount
	 *            the amount available in the store.
	 * @param minAmount
	 *            the minimal amount which should be available.
	 */
	void insertStockItem(IProduct product, int salesPrice, int amount,
			int minAmount) throws Exception;

	/**
	 * Get the current amount of a product in this store.
	 * 
	 * @param product
	 *            the product whose amount we are interested in.
	 * @return the amount of the given product available in this store.
	 */
	int getAmount(IProduct product) throws Exception;

	/**
	 * Creates a new, empty order, which can be filled with order items and
	 * executed in the ordering process.
	 */
	IOrder createOrder() throws Exception;

	/**
	 * Execute an order, i.e., we are done with adding products to that order so
	 * it can be sent out.
	 * 
	 * @param order
	 *            the order being executed.
	 */
	void executeOrder(IOrder order) throws Exception;

	/**
	 * Indicates that all products of this order have been received, so they
	 * should be added to the current stock.
	 * 
	 * @param order
	 *            the order being delivered.
	 */
	void rollInOrder(IOrder order) throws Exception;
}
