package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface of the printer which is used to print receipts. This has a lot less
 * detail than the UserDisplay, because testing correct system reaction can be
 * checked by investigating the UserDisplay alone. This interface is only used
 * to see if the printer gets any messages at all.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface IPrinter extends IUpdateReceiver {

	/**
	 * Returns the last printout produced by this printer. As the format of the
	 * printout is nowhere defined, this is used for logging purposes only.
	 */
	String getLastPrintout() throws Exception;
}
