package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface for an order. It holds just a single simple method for adding
 * products to this order. Furthermore it is used as a representation for orders
 * when passing them to other methods (so an implementation might want to
 * contain a primary key or something analogous).
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Revision: 1.1 $
 * @levd.rating GREEN Rev: 47
 */
public interface IOrder {

	/**
	 * Adds a item to this order. Further data required (e.g. supplier) should
	 * be filled in by the testdriver.
	 * 
	 * @param product
	 *            the product to order.
	 * @param amount
	 *            amount to order.
	 */
	public void addOrderItem(IProduct product, int amount) throws Exception;
}
