package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface for the lights display at a cash desk. This contains a light
 * indicating express mode activity and a light indicating that no credit cards
 * are accepted. For the reference implementation both lights are used at the
 * same time. However the "no credit card light" might also be useful to
 * indicate a missing bank caonnection.
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Revision: 1.1 $
 * @levd.rating GREEN Rev: 47
 */

public interface ILightsDisplay extends IUpdateReceiver {

	/**
	 * Returns true, if the express mode light is on
	 */
	public boolean isExpressModeLightOn() throws Exception;

	/**
	 * Returns ture, if the no credit card light is on
	 */
	public boolean isNoCreditCardLightOn() throws Exception;
}
