package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface of the entire enterprise. This is used to create new products and
 * check some global conditions on order state (so for most implementations this
 * is just another database wrapper).
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface IEnterprise {

	/**
	 * Creates a new product. This is used for the initial creation of test
	 * data. Additional fields required by the database should be provided by
	 * the test driver.
	 * 
	 * @param barcode
	 *            the barcode of the product.
	 * @param purchasePrice
	 *            the purchase price in Cent.
	 * @param name
	 *            the name of the product.
	 * @return the product created.
	 */
	IProduct createProduct(int barcode, int purchasePrice, String name)
			throws Exception;

	/**
	 * Returns whether there is a product transfer requested (might be visible
	 * by orders in the database). The number of products is not relevant here.
	 * 
	 * @param product
	 *            the product to be transfered.
	 * @param storeFrom
	 *            the store which has to deliver the product.
	 * @param storeTo
	 *            the store which should receive the product.
	 * @return whether there is a product transfer requested.
	 */
	boolean existsProductTransfer(IProduct product, IStorePC storeFrom,
			IStorePC storeTo);
}
