package org.cocome.tradingsystem.systests.interfaces;

/**
 * The main interface of a single cash desk. This is the view the environment
 * (and thus the system test) has on the system, so the cash desk is just a
 * provider for a number of peripheral devices.
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 65 $
 * @levd.rating GREEN Rev: 65
 */
public interface ICashDesk {

	/** Returns the card reader for this cash desk. */
	ICardReader getCardReader() throws Exception;

	/** Returns the cashbox for this cash desk. */
	ICashBox getCashBox() throws Exception;

	/** Returns the bar code scanner for this cash desk. */
	IBarcodeScanner getBarcodeScanner() throws Exception;

	/** Returns the printer for this cash desk. */
	IPrinter getPrinter() throws Exception;

	/** Returns the user display for this cash desk. */
	IUserDisplay getUserDisplay() throws Exception;

	/** Returns the lights display for this cash desk. */
	ILightsDisplay getLightsDisplay() throws Exception;

	/**
	 * Specifies the number of express sales (sales with less then 8 itmes)
	 * needed to switch cash desk in express mode
	 * @returns nummber of required express sales for express mode
	 */
	int getNumberOfExpressSalesForExpressModeSwitch();
}
