package org.cocome.tradingsystem.systests.interfaces;

/**
 * Interface of the cashbox consisting of a "box" containing the money and some
 * keys allowing user input. We do not model explicit key presses at this level.
 * It is the responsibility of the test driver to resolve these high level
 * commands to single key strokes if the application requires this.
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface ICashBox extends IUpdateReceiver {

	/**
	 * Returns whether the open signal for the cashbox has been sent (and not
	 * yet been read).
	 */
	boolean wasOpenSignalSent() throws Exception;

	/**
	 * Returns the current status of the cashbox to the system. This is called
	 * only when the status changes, but the test driver may support some
	 * polling mechanism or regular sending of the status if the implementation
	 * of the system requires this.
	 * 
	 * @param closed
	 *            true if the cashbox is closed.
	 */
	void setCashboxStatus(boolean closed) throws Exception;

	/** Corresponds to pressing the "new sale" button. */
	void startNewSale() throws Exception;

	/** Corresponds to pressing the "sale finished" button. */
	void finishSale() throws Exception;

	/** Corresponds to pressing the "cash payment" button. */
	void startCashPayment() throws Exception;

	/** Corresponds to pressing the "credit card payment" button. */
	void startCreditCardPayment() throws Exception;

	/**
	 * Enter the amount of cash received. This might be resolved to multiple key
	 * presses by the test driver.
	 * 
	 * @param centAmount
	 *            the amount in Cent (or whatever currency)
	 */
	void enterReceivedCash(int centAmount) throws Exception;

	/**
	 * Manually enable the credit card reader to be able to take credit card
	 * payment while in expressmode
	 */
	void manuallyEnableCreditCardReader() throws Exception;
}
