package org.cocome.tradingsystem.systests.interfaces;

/**
 * The interface for the card reader used to get credit card information and
 * enter the card pin.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface ICardReader {

	/**
	 * Reports the number read from the credit card. If the implementation
	 * represents credit card numbers using some specialized data structure, the
	 * test driver is responsible for mapping the integer numbers to those data
	 * structures and back.
	 * 
	 * @param cardNumber
	 *            the number of the credit card.
	 * 
	 */
	void enterCard(int cardNumber) throws Exception;

	/**
	 * Reports the pin entered at the card reader. If the implementation
	 * represents pin numbers using some specialized data structure, the test
	 * driver is responsible for mapping the integer numbers to those data
	 * structures and back.
	 * 
	 * @param pin
	 *            the pin code entered by the user.
	 */
	void enterPin(int pin) throws Exception;
}
