package org.cocome.tradingsystem.systests.interfaces;

/**
 * This is the interface used for a bank. There is exactly one bank in the
 * entire system which is used for all credit card checks. The bank is not
 * checked for events but is just used to manage credit cards (so we know which
 * ones are valid).
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 47 $
 * @levd.rating GREEN Rev: 47
 */
public interface IBank {

	/**
	 * Create a new credit card for this bank. If a card of this number already
	 * exists, the old card will be replaced.
	 * 
	 * @param cardNumber
	 *            the number for this card.
	 * @param pinNumber
	 *            the secret pin code for the credit card.
	 * @param availableMoney
	 *            the amount of money in cents associated with this card.
	 */
	void createCreditCard(int cardNumber, int pinNumber, int availableMoney)
			throws Exception;

	/**
	 * Returns the amount of money (in cents) available for this card.
	 * 
	 * @param cardNumber
	 *            the number for this card.
	 */
	int getAvailableMoney(int cardNumber) throws Exception;

	/**
	 * Deletes the given credit card. If the card does not exist, nothing
	 * happens.
	 * 
	 * @param cardNumber
	 *            the number of card to be deleted.
	 */
	void deleteCreditCard(int cardNumber) throws Exception;
}
