package eu.qimpress.ide.backbone.tests;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.junit.Test;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

public class TwoSubsequentCalls_IQAlternative_getTemporaryFolder extends BackboneTest {
	protected static final String TEST_ALTERNATIVE_1_NAME = "alternative_001";
	@Test
	public void TestTwoSubsequentCalls() {
		System.err.println(">> TEST: TWO SUSEQUENT CALLS OF IQAlternative_getTemporaryFolder <<: ");
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		IQProject qproject = (IQProject) QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
		IQAlternative alternative = null;
		try{
			IQRepository repository = qproject.getRepository();
			assertNotNull("Can not get handle to repository", repository);
			alternative = repository.createAlternative(TEST_ALTERNATIVE_1_NAME);
			try{
				IFolder folder1 = alternative.getTemporaryFolder();
				IFolder folder2 = alternative.getTemporaryFolder();
				assertTrue(folder1.equals(folder2));
			}catch (CoreException e){
				e.printStackTrace();
				fail("Can to get the folder...");
			}
			assertTrue (alternative != null);
		}catch (RepositoryException e){
			e.printStackTrace();
			fail("Can not get respository...");
		}
	}
	
}
