package eu.qimpress.ide.backbone.tests;

import static org.junit.Assert.*;

//import org.eclipse.emf.ecore.EObject; 

import org.junit.Before;
import org.junit.After;
import org.junit.Test;

import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject; 


import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore; 
import org.eclipse.jdt.core.IJavaProject; 
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.action.IAction;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.internal.resources.*;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.runtime.*;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.*;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
//import eu.qimpress.ide.backbone.core.internal.model.QDirectoryRepositoryImpl;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.QImpressNature;
import eu.qimpress.ide.backbone.core.ui.actions.ToggleQImpressNatureAction;


public class ProjectManagementTest extends BackboneTest {
	
		
	@Test
	public void testGetHandleToCurrentWorkspace() {
		System.err.println(">> TEST: GET HANDLE TO WORKSPACE <<: ");
		IWorkspace workspace = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace();
		assertNotNull("Can not get handle to current QProject", workspace);
	}
	
	
	@Test
	public void testListProjects() {	
		int i, j;
		
		System.err.println(">> TEST: LIST EXISTING PROJECTS <<: ");
		
		IProject[] allprojects = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProjects();
		
		if (allprojects.length == 0){
			System.err.println("There are no projects in workspace...");
		}
		
		String[] NatureIDsx;
		for (i = 0; i < allprojects.length; i++){
			System.err.println(" PROJECT: " + allprojects[i].getProject().getName());
			try {
				NatureIDsx = allprojects[i].getProject().getDescription().getNatureIds();
				for (j = 0; j < NatureIDsx.length; j++){
					System.err.println("    -has nature >> : " + NatureIDsx [j]);
				}
			} catch (CoreException e) {
				e.printStackTrace();
				fail("Cannot get list of project description...");
			}
		}
	}
	
	@Test
	public void testQimpressNaturePropertiesInitielised() {
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		assertTrue("Alternative folder was not created properly..", project.getFolder("alternatives").exists());
	}
}
	



