package eu.qimpress.ide.backbone.tests;

import static org.junit.Assert.*;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.eclipse.core.resources.IProject;
import org.junit.Test;

import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;


public class ParameterProviderTest extends BackboneTest {
	
	private String parameterKey =   new String("paramKey1");
	private String parameterValue = new String("value1"); 
	
	@Test
	public void testCreateParameter() {
		System.err.println(">> TEST: PARAMETER PROVIDER <<: ");
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		IQProject qproject = (IQProject) QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
		try{
			
			
			IQRepository repository = qproject.getRepository();
			
			assertNotNull("Can not get handle to repository", repository);
			repository.setParameter(parameterKey, parameterValue);
			
			assertTrue (repository.containsKey(parameterKey));
			
		}catch (RepositoryException e){
			e.printStackTrace();
			fail("Can not get respository...");
		}
	}
	
	
	@Test
	public void testStroreLoadCompareDeleteParameter() {
		System.err.println(">> TEST: CREATE ALTERNATIVES <<: ");
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		IQProject qproject = (IQProject) QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
		try{
			
			IQRepository repository = qproject.getRepository();
			
			assertNotNull("Can not get handle to repository", repository);
			repository.setParameter(parameterKey, parameterValue);
			
			assertTrue (repository.containsKey(parameterKey));
			
			//repository.getParameter(parameterKey);
			
			
			System.err.println((String) repository.getParameter(parameterKey));
			System.err.println(parameterValue);
			assertTrue((repository.getParameter(parameterKey).equals(parameterValue)));
			
			repository.setParameter(parameterKey, null);
			assertFalse (repository.containsKey(parameterKey));
			
			assertNull(repository.getParameter(parameterKey));
			
			
		}catch (RepositoryException e){
			e.printStackTrace();
			fail("Can not get respository...");
		}
	}	
	
	
}
