package eu.qimpress.ide.backbone.tests;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.junit.Before;
import org.junit.Test;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;



import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;

public class ModelManipulationTest  extends BackboneTest {
	
	protected IQAlternative alternative;
	protected static final String TEST_ALTERNATIVE_1_NAME = "alternative_001";
	
	@Before
	public void createAlternative(){
		System.err.println(">> TEST: CREATE ALTERNATIVES <<: ");
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		IQProject qproject = (IQProject) QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
		try{
			IQRepository repository = qproject.getRepository();
			assertNotNull("Can not get handle to repository", repository);
			alternative = repository.createAlternative(TEST_ALTERNATIVE_1_NAME);
			assertTrue (alternative != null);
		}catch (RepositoryException e){
			e.printStackTrace();
			fail("Can not get respository...");
		}
		
	}
	
	
	@Test
	public void createEmptyModel() { 
		System.err.println("Create empty model action");
		
		// FIXME put here selection dialog of alternatives
		//IQAlternative alternative = (IQAlternative) QImpressApplicationModelManager.getManager().getQAppModel().getElementByID("65821f03-b3a6-4720-9ea5-1ab3fa828d7a");
		
		if (alternative != null) {
			IQModel model;
			try {
				model = alternative.getModel("seff");
				EObject eo = model.getTopLevelEObject();
				System.err.println("Top-level object of empty model: " + eo);				
			} catch (RepositoryException e) {
				e.printStackTrace();
			}
		}else {
			fail("Not a valid alternative");
		}
		
		System.err.println("Empty model created");
	}
	
	protected EObject createSampleModel() {
		StaticstructureFactory factory = StaticstructureFactory.eINSTANCE;
		
		// top-level element
		Repository repo = factory.createRepository();
		repo.setName("Testing repository");

		Interface iface = factory.createInterface();
		iface.setName("Iface");

		repo.getInterface().add(iface);

		return repo;
	}	
	
	
	@Test
	public void storeModel() {
		System.err.println("Store model action");

		if (alternative != null) {
			EObject sampleModel = createSampleModel();

			try {
				System.err.println("- Storing model: " + sampleModel);

				String filename = "test-repo";
				String modelType = RepositoryModels.REPOSITORY_MODEL_EXT;

				alternative.storeEObject(sampleModel, filename, modelType);
			} catch (RepositoryException e) {
				e.printStackTrace();
				MessageDialog.openError(null, "Error",
						"Cannot store model into alternative");
			}

			System.err.println("Model successfully stored");
		}
	}	

}
