package eu.qimpress.ide.backbone.tests;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.junit.Before;
import org.junit.Test;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;

public class DeleteProjectTest  extends BackboneTest{
	
	@Test
	public void DeleteProjectsTest() {
		System.err.println(">> TEST: DELETE PROJECTS (see bug 78 from JIRA) <<: ");
		
		
		
		QImpressApplicationModelManager mgr = QImpressApplicationModelManager.getManager();
		IQApplicationModel appmodel = mgr.getQAppModel();
		IQProject [] list = appmodel.getQProjects();
		
		int numProjectsBefore = list.length;
		System.err.println("  listing projects before: ");
		for ( IQProject project : list) {
			System.err.println("     " + project);
		}
		System.err.println(" ");
		
		String proj1 = java.util.UUID.randomUUID().toString();
		createOImpressNatureProject(proj1);
		String proj2 = java.util.UUID.randomUUID().toString();
		createOImpressNatureProject(proj2);
		String proj3 = java.util.UUID.randomUUID().toString();
		createOImpressNatureProject(proj3);
		
		list = appmodel.getQProjects();
		int numProjectsAfterCreation = list.length;
		assertTrue(numProjectsAfterCreation == numProjectsBefore + 3);
		System.err.println("  listing projects after creation: ");
		for ( IQProject project : list) {
			System.err.println("     " + project);
		}
		System.err.println(" ");
		
		
		deleteTestProject(proj1);
		deleteTestProject(proj2);
		deleteTestProject(proj3);
		
		
		list = appmodel.getQProjects();
		int numProjectsAfterDelete = list.length;
		System.err.println("  listing projects after deletion: ");
		for ( IQProject project : list) {
			System.err.println("     " + project);
		}
		System.err.println(" ");

		assertTrue(numProjectsAfterDelete == numProjectsBefore);
	}
}
