package eu.qimpress.ide.backbone.tests;
import static org.junit.Assert.assertFalse;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.junit.After;
import org.junit.Before;
import java.util.UUID;


//import eu.qimpress.ide.backbone.core.internal.model.QDirectoryRepositoryImpl;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.QImpressNature;

/**
 * 
 * @author Tomas Pop
 * 
 * This class is ancestor for all tests. It implements method with @before and @after 
 * annotation (executed befor and after every test)   
 *
 */
public abstract class BackboneTest {

	protected static String TEST_PROJECT_NAME;
	
	private int NrProjectsBefore;
	private int NrQProjectsBefore;
	
	public BackboneTest(){
		TEST_PROJECT_NAME = java.util.UUID.randomUUID().toString();
	}
	
	@Before
	public void createOImpressNatureProject(){
		IProject[] allprojects = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProjects();
		NrProjectsBefore = allprojects.length;
		
		IQProject[] qprojects = QImpressApplicationModelManager.getManager().getQAppModel().getQProjects();
		NrQProjectsBefore = qprojects.length;
		createOImpressNatureProject(TEST_PROJECT_NAME);
		
		IProject newproj = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		assertNotNull(newproj);
		
		allprojects = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProjects();
		assertTrue(allprojects.length == NrProjectsBefore + 1);
	}
	
	
	public void createOImpressNatureProject(String name){
		
		
		
		String projectName = new String(name);
		IClasspathEntry[] classPathEntries;
		IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		assertFalse("Can not proceed test, because project already exists" ,project.exists());
	
		
		IProgressMonitor monitor = new NullProgressMonitor();
		
		
		
		try {
			project.create(monitor);
			project.open(monitor);
		} catch (CoreException e) {
			e.printStackTrace();
			fail("Cannot create project folder");
		}
		
		IPath projectFolderPath = new Path(projectName);
		IFolder projectFolder = project.getFolder(projectFolderPath);
		
		IPath repositoryLocation = new Path(projectName + "/" + //QDirectoryRepositoryImpl.DEFAULT_REPOSITORY_LOCATION);
				"alternatives");
		IFolder repositoryFolder = project.getFolder(repositoryLocation);
		
		try{
			projectFolder.create(true, true, null);
			//repositoryFolder.create(true, true, null);
		} catch (CoreException e) {
			e.printStackTrace();
			fail("Cannot create project folder");
		}
		JavaCore.newSourceEntry(project.getFullPath().append(projectFolderPath));
		
		classPathEntries = PreferenceConstants.getDefaultJRELibrary();
		
		IJavaProject javaProject = JavaCore.create(project);
		
		IProjectDescription projectDescription;
		
		try{
			projectDescription = project.getDescription();
			String[] natureIDs = projectDescription.getNatureIds();
			
			String[] natureIDsExtended = new String[natureIDs.length + 2];
			
			System.arraycopy(natureIDs, 0, natureIDsExtended, 0, natureIDs.length);
			natureIDsExtended[natureIDs.length] = JavaCore.NATURE_ID;
			natureIDsExtended[natureIDs.length + 1] = QImpressNature.NATURE_ID;
			
			
			projectDescription.setNatureIds(natureIDsExtended);
			
			project.setDescription(projectDescription, monitor);
			
			PreferenceConstants.getPreferenceStore().getString(PreferenceConstants.SRCBIN_SRCNAME);
			
			
			
			javaProject.setRawClasspath(classPathEntries, monitor);
			
			IWorkspace workspace = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace();
			
			workspace.save(true, monitor);
			project.refreshLocal(IResource.DEPTH_INFINITE, monitor);
			workspace.save(true, monitor);
			QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
			
		    try {
				Thread.currentThread().sleep(2000);
		    } catch  (InterruptedException e) {
		    	e.printStackTrace();
				fail("Sleep...");
		    }
		    project.refreshLocal(IResource.DEPTH_INFINITE, monitor);
			
		} catch (CoreException e) {
			e.printStackTrace();
			fail("Cannot get list of project description...");
		}
		
		// Now, new project with Q-impress nature should be created...
		
		
		
		System.err.println("  -CREATED TEST PROJECT " + name + " ...");
	}	
	
	
	@After	
	public void deleteTestProject(){
		
		deleteTestProject(TEST_PROJECT_NAME);
		IProject[] allprojects = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProjects();
		assertTrue(allprojects.length == NrProjectsBefore);
		
	}
	
	 public void deleteTestProject(String name){
		IProgressMonitor monitor = new NullProgressMonitor();
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(name);
		try {
			project.delete(true, monitor);
			project.refreshLocal(IResource.DEPTH_INFINITE, monitor);
			IProject[] allprojects = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProjects();
		}catch (CoreException e) {
				e.printStackTrace();
				fail("Cannot get list of project description...");
		}
		
		
		System.err.println("  -DELETED TEST PROJECT...");
	}
}
