package eu.qimpress.ide.backbone.tests;

import static org.junit.Assert.assertFalse;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.eclipse.core.internal.resources.InternalTeamHook;
import org.eclipse.core.resources.IProject;
import org.junit.Test;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;




public class AlternativeManipulationTest extends BackboneTest {
	
	protected static final String TEST_ALTERNATIVE_1_NAME = "alternative_001";
	protected static final String TEST_ALTERNATIVE_2_NAME = "alternative_002";
	protected static final String TEST_SUBALTERNATIVE_1_NAME = "subalternative_001";
	protected static final String TEST_SUBALTERNATIVE_2_NAME = "subalternative_002";
	
	
	protected void deleteAlternativeRecursively(IQAlternative alternative, IQRepository repository) throws RepositoryException{
		IQElement[] ChildAlternatives = alternative.getChildren();
		System.err.println("Handling alternative: " + alternative.getInfo().getId());
		System.err.println("Alternative: " + alternative.getInfo().getId() + " has " + String.format("%d", ChildAlternatives.length));
		if (ChildAlternatives.length > 0){
			
			int i;
			for (i=0; i< ChildAlternatives.length; i++){
				deleteAlternativeRecursively((IQAlternative)ChildAlternatives[i], repository);
			}
		}
		
		try {
			System.err.println("Going to delete alternative" + alternative.getInfo().getId());
			
			repository.deleteAlternative(alternative);
		}catch (RepositoryException e){
			
			fail("Can not delete Alternative..." + e.getMessage());
		}
		
	}
	
	protected void deleteAllAlternatives(IQProject qproject, IQRepository repository) throws RepositoryException{
		IQAlternative[] topLevelAlternatives = repository.listTopLevelAlternatives();
		int i = 0;
		for (i = 0; i < topLevelAlternatives.length; i++){
			deleteAlternativeRecursively(topLevelAlternatives[i], repository);
		}
		
	}
	
	protected void prepareTestEnvironment(IQProject qproject, IQRepository repository) throws RepositoryException{
		deleteAllAlternatives(qproject, repository);
		
		IQAlternative[] topLevelAlternativesBefore = repository.listTopLevelAlternatives();
		assertTrue("test environment is assumed to be without alteratives before test", topLevelAlternativesBefore.length == 0);
	}
	
	
	/**
	 * Test creation of alternatives. Creates two alternatives, check that alternative
	 * folders are present and that this new alternatives have no child.
	 * @param qproject
	 * @param repository
	 * @throws RepositoryException
	 */
	protected void createTopLevelAlternatives (IQProject qproject, IQRepository repository) throws RepositoryException{
			IQAlternative[] topLevelAlternativesBefore = repository.listTopLevelAlternatives();
			
			repository.createAlternative(TEST_ALTERNATIVE_1_NAME);
			repository.createAlternative(TEST_ALTERNATIVE_2_NAME);
			
			IQAlternative[] topLevelAlternativesAfter = repository.listTopLevelAlternatives();
			
			
			assertTrue(topLevelAlternativesAfter.length == topLevelAlternativesBefore.length + 2);
			
			/* test that all alternatives are top level*/
			for (int i = 0; i < topLevelAlternativesAfter.length; i++){
				assertTrue(topLevelAlternativesAfter[i].isTopLevel());
			}
	}
	
	
	protected void deleteTopLevelAlternatives (IQProject qproject, IQRepository repository) throws RepositoryException{
		
		IQAlternative[] topLevelAlternatives = repository.listTopLevelAlternatives();
			
		assertTrue ("Some alternatives were not created", topLevelAlternatives.length == 2);
		
		repository.deleteAlternative(topLevelAlternatives[0]);
		repository.deleteAlternative(topLevelAlternatives[1]);
		
		topLevelAlternatives = repository.listTopLevelAlternatives();
		
		assertTrue ("Some alternatives were not deleted", topLevelAlternatives.length == 0);
	}
	
	protected void createDeleteSubLevelAlternatives (IQProject qproject, IQRepository repository) throws RepositoryException{
		
		IQAlternative[] topLevelAlternatives = repository.listTopLevelAlternatives();
			
		assertTrue ("Some alternatives were not created", topLevelAlternatives.length == 2);
		
		
		repository.createAlternative(topLevelAlternatives[0],TEST_SUBALTERNATIVE_1_NAME);
		repository.createAlternative(topLevelAlternatives[0],TEST_SUBALTERNATIVE_2_NAME);
		
		//assertTrue("Top level alternative childs were not created", topLevelAlternatives[0].hasChildren());
		
		IQElement[] ChildAlternatives = topLevelAlternatives[0].getRepository().getChildren(topLevelAlternatives[0]);
		
		assertTrue("Child alternatives were not created", ChildAlternatives.length == 2);
		
		((IQAlternative)ChildAlternatives[0].getParent()).equals(topLevelAlternatives[0]);
		((IQAlternative)ChildAlternatives[1].getParent()).equals(topLevelAlternatives[0]);
		
		repository.deleteAlternative((IQAlternative)ChildAlternatives[0]);
		repository.deleteAlternative ((IQAlternative)ChildAlternatives[1]);
		
		ChildAlternatives = (IQAlternative[]) topLevelAlternatives[0].getRepository().getChildren(topLevelAlternatives[0]);	
		assertTrue(ChildAlternatives.length == 0);	
		 
	}

	
	@Test
	public void testCreateDeleteAlternatives() {
		System.err.println(">> TEST: CREATE ALTERNATIVES <<: ");
		IProject project = QImpressApplicationModelManager.getManager().getQAppModel().getWorkspace().getRoot().getProject(TEST_PROJECT_NAME);
		IQProject qproject = (IQProject) QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
		try{
			IQRepository repository = qproject.getRepository();
			assertNotNull("Can not get handle to repository", repository);
			try{
				prepareTestEnvironment(qproject, repository);
			}catch (RepositoryException e){
				fail("Can not prepare repository...");
			}
			createTopLevelAlternatives(qproject, repository);
			createDeleteSubLevelAlternatives(qproject, repository);
			deleteTopLevelAlternatives(qproject, repository);
			
		}catch (RepositoryException e){
			e.printStackTrace();
			fail("Can not get respository...");
		}
	}
	
}
