package eu.qimpress.ide.backbone.tests.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.StaticstructureFactory;

/**
 * 
 * @author Michal Malohlava
 * 
 */
public class StoreModelAction implements IWorkbenchWindowActionDelegate {

	private IWorkbenchWindow window;

	public StoreModelAction() {
	}

	/**
	 * The action has been activated. The argument of the method represents the
	 * 'real' action sitting in the workbench UI.
	 * 
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		System.err.println("Store model action");

		// FIXME put here selection dialog of alternatives
		IQAlternative alternative = (IQAlternative) QImpressApplicationModelManager
				.getManager().getQAppModel().getElementByID(
						"65821f03-b3a6-4720-9ea5-1ab3fa828d7a");

		if (alternative != null) {
			EObject sampleModel = createSampleModel();

			try {
				System.err.println("- Storing model: " + sampleModel);

				String filename = "test-repo";
				String modelType = RepositoryModels.REPOSITORY_MODEL_EXT;

				alternative.storeEObject(sampleModel, filename, modelType);
			} catch (RepositoryException e) {
				e.printStackTrace();
				MessageDialog.openError(null, "Error",
						"Cannot store model into alternative");
			}

			System.err.println("Model successfully stored");
		}
	}

	protected EObject createSampleModel() {
		StaticstructureFactory factory = StaticstructureFactory.eINSTANCE;

		// top-level element
		Repository repo = factory.createRepository();
		repo.setName("Testing repository");

		Interface iface = factory.createInterface();
		iface.setName("Iface");

		repo.getInterface().add(iface);

		return repo;
	}

	/**
	 * Selection in the workbench has been changed. We can change the state of
	 * the 'real' action here if we want, but this can only happen after the
	 * delegate has been created.
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * We can use this method to dispose of any system resources we previously
	 * allocated.
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * We will cache window object in order to be able to provide parent shell
	 * for the message dialog.
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
		this.window = window;
	}
}