package eu.qimpress.ide.ui.provider;

import eu.qimpress.samm.datatypes.CollectionDataType;
import eu.qimpress.samm.datatypes.ComplexDataType;
import eu.qimpress.samm.datatypes.PrimitiveDataType;
import eu.qimpress.samm.datatypes.util.DatatypesSwitch;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

/**
 * @author wsa
 *
 */
public class OperationPrinter extends StaticstructureSwitch<String> {

	private DataTypesPrinter typesPrinter = new DataTypesPrinter();
	
	@Override
	public String caseOperation(Operation object) {
		String result = "";
		if (object.getOutput() != null) {
			result += "<" + this.doSwitch(object.getOutput()) + "> ";
		} else {
			result += "void ";
		}
		result += object.getName();
		if (object.getInput() != null) {
			result += "(" + this.doSwitch(object.getInput()) + ")";
		} else {
			result += "()";
		}
		return result;
	}
	
	@Override
	public String caseMessageType(MessageType object) {
		String result = "";
		for (Parameter param : object.getParameters()) {
			result += this.doSwitch(param) + ", ";
		}
		if (object.getParameters().size() > 0) {
			result = result.substring(0, result.length()-2);
		}
		return result;
	}
	
	@Override
	public String caseParameter(Parameter object) {
		String result = "";
		if (object.getType() != null){
			result += typesPrinter.doSwitch(object.getType());
		} else {
			result += "void";
		}
		result += " " + object.getName();
		return result;
	}

	public class DataTypesPrinter extends DatatypesSwitch<String> {
		
		@Override
		public String caseCollectionDataType(CollectionDataType object) {
			return this.doSwitch(object.getInnertype()) + "[]";
		}
		
		@Override
		public String caseComplexDataType(ComplexDataType object) {
			return object.getName();
		}
		
		@Override
		public String casePrimitiveDataType(PrimitiveDataType object) {
			return object.getType().getLiteral().toLowerCase();
		}
	}
	
}
