package eu.qimpress.ide.ui.dialogs.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

/**
 * @author wsa
 *
 */
public class ExcludingFilteringItemProvider extends FilteringItemProvider {

	Set<EReference> excludedContainments;
	
	public ExcludingFilteringItemProvider(AdapterFactory adapterFactory,
			Collection<?> filterList,
			Collection<EReference> additionalChildReferences,
			Set<EReference> excludedContainments) {
		super(adapterFactory, filterList, additionalChildReferences);
		if (excludedContainments == null) throw new IllegalArgumentException("excludedContainments set is null");
		this.excludedContainments = excludedContainments;
	}

	@Override
	public Collection<?> getChildren(Object object) {
		Collection<EObject> result = (Collection<EObject>) super.getChildren(object);
		ArrayList<EObject> filteredResult = new ArrayList<EObject>();
		for (EObject nextObject : result) {
			if (nextObject != null && !excludedContainments.contains(nextObject.eContainmentFeature())) {
				filteredResult.add(nextObject);
			}
		}
		return filteredResult;
	}
	
}
