package eu.qimpress.ide.ui.dialogs.selection;

import java.util.Collection;
import java.util.Set;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.provider.DecoratorAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemProviderDecorator;

/**
 * @author wsa
 *
 */
public class ExcludingFilteredItemsAdapterFactory extends DecoratorAdapterFactory {

	private Collection<?> filterList;
	private Collection<EReference> additionalChildReferences;
	private Set<EReference> excludedContainments;

	public ExcludingFilteredItemsAdapterFactory(AdapterFactory decoratedAdapterFactory, 
			Collection<?> filterList, 
			Collection<EReference> childReferences,
			Set<EReference> excludedContainments) {
		super(decoratedAdapterFactory);
		this.filterList = filterList;
		this.additionalChildReferences = childReferences;
		this.excludedContainments = excludedContainments;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.DecoratorAdapterFactory#createItemProviderDecorator(java.lang.Object, java.lang.Object)
	 */
	@Override
	protected IItemProviderDecorator createItemProviderDecorator(Object target,
			Object Type) {
		IItemProviderDecorator decoredProvider = new ExcludingFilteringItemProvider(this,filterList,additionalChildReferences,excludedContainments);
		decoredProvider.setDecoratedItemProvider((IChangeNotifier)getDecoratedAdapterFactory().adapt(target, Type));
		return decoredProvider;
	}

	
}
