package eu.qimpress.ide.editors.text.xtextfix.hooks;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.xtext.parsetree.reconstr.impl.InstanceDescriptF1X;
import org.eclipse.xtext.parsetree.reconstr.impl.InstanceDescription;

/**
 * This class loading hook replace {@link InstanceDescription} class by a new
 * implementation from XText SVN HEAD.
 * 
 * The replacement is motivated by wrong serialization of Xtext 0.7.2 (see bug
 * <a href="https://bugs.eclipse.org/bugs/show_bug.cgi?id=280439">280439</a>). 
 * The replacement process is based on early loading of fixed class {@link InstanceDescriptF1X}, renaming
 * its bytecode to the right name and remembering the resulting bytecode. During the loading of original class the 
 * remembered bytecode is returned. :-)
 * 
 * To launch the hook, it has to be installed as a jar (must not be unpacked) and the eclipse has to be launched with parameter
 * -Dosgi.framework.extensions=eu.qimpress.ide.editors.text.xtextfix
 * 
 * @see InstanceDescriptF1X
 * @see InstanceDescription
 * @see LoadClassOnStartup
 * 
 * @author Michal Malohlava
 * 
 */
@SuppressWarnings("restriction")
public class XtextInstanceDescriptionClassLoadingHook implements
		ClassLoadingHook, HookConfigurator {

	private static final String PATCHED_XTEXT_CLASS = "org.eclipse.xtext.parsetree.reconstr.impl.InstanceDescriptF1X";
	private static final String TO_PATCHE_XTEXT_CLASS = "org.eclipse.xtext.parsetree.reconstr.impl.InstanceDescription";
	private static final byte[] PATTERN_TO_FIND = { 't', 'F', '1', 'X' };
	private static final byte[] PATTERN_TO_REPLACE = { 't', 'i', 'o', 'n' };

	boolean initialized = false;
	byte[] PATCHED_CLASS_BYTES;

	@Override
	public byte[] processClass(String name, byte[] classbytes,
			ClasspathEntry classpathEntry, BundleEntry entry,
			ClasspathManager manager) {

		if (PATCHED_XTEXT_CLASS.equals(name)) {
			System.out.println("Patching branch: class loading "
					+ PATCHED_XTEXT_CLASS);

			// this is a simple way of renaming the class believing that pattern 'tF1X' does not occurred inside the class
			PATCHED_CLASS_BYTES = Arrays.copyOf(classbytes, classbytes.length);
			for (int i = 0; i < PATCHED_CLASS_BYTES.length - 3; i++) {
				if (PATCHED_CLASS_BYTES[i] == PATTERN_TO_FIND[0]
						&& PATCHED_CLASS_BYTES[i + 1] == PATTERN_TO_FIND[1]
						&& PATCHED_CLASS_BYTES[i + 2] == PATTERN_TO_FIND[2]
						&& PATCHED_CLASS_BYTES[i + 3] == PATTERN_TO_FIND[3]) {
					PATCHED_CLASS_BYTES[i] = PATTERN_TO_REPLACE[0];
					PATCHED_CLASS_BYTES[i + 1] = PATTERN_TO_REPLACE[1];
					PATCHED_CLASS_BYTES[i + 2] = PATTERN_TO_REPLACE[2];
					PATCHED_CLASS_BYTES[i + 3] = PATTERN_TO_REPLACE[3];
				}
			}

			initialized = true;
		} else if (TO_PATCHE_XTEXT_CLASS.equals(name)) {
			System.out.println("To patch branch: replacing "
					+ TO_PATCHE_XTEXT_CLASS);

			if (initialized) {
				return PATCHED_CLASS_BYTES;
			}
		}

		return null;
	}

	@Override
	public void addHooks(HookRegistry hookRegistry) {
		hookRegistry.addClassLoadingHook(this);
	}

	@Override
	public boolean addClassPathEntry(ArrayList cpEntries, String cp,
			ClasspathManager hostmanager, BaseData sourcedata,
			ProtectionDomain sourcedomain) {
		return false;
	}

	@Override
	public BaseClassLoader createClassLoader(ClassLoader parent,
			ClassLoaderDelegate delegate, BundleProtectionDomain domain,
			BaseData data, String[] bundleclasspath) {
		return null;
	}

	@Override
	public String findLibrary(BaseData data, String libName) {
		return null;
	}

	@Override
	public ClassLoader getBundleClassLoaderParent() {
		return null;
	}

	@Override
	public void initializedClassLoader(BaseClassLoader baseClassLoader,
			BaseData data) {
	}

}
