/**
 * <copyright>
 * </copyright>
 *

 */
package eu.qimpress.ide.editors.text.tbp.util;

import eu.qimpress.ide.editors.text.tbp.APTerm;
import eu.qimpress.ide.editors.text.tbp.ARStatement;
import eu.qimpress.ide.editors.text.tbp.Annotation;
import eu.qimpress.ide.editors.text.tbp.Block;
import eu.qimpress.ide.editors.text.tbp.ComponentBehaviorProtocol;
import eu.qimpress.ide.editors.text.tbp.Condition;
import eu.qimpress.ide.editors.text.tbp.Imperative;
import eu.qimpress.ide.editors.text.tbp.MethodCall;
import eu.qimpress.ide.editors.text.tbp.MethodDeclaration;
import eu.qimpress.ide.editors.text.tbp.MethodName;
import eu.qimpress.ide.editors.text.tbp.PAlternative;
import eu.qimpress.ide.editors.text.tbp.PAndParallel;
import eu.qimpress.ide.editors.text.tbp.PEvent;
import eu.qimpress.ide.editors.text.tbp.POrParallel;
import eu.qimpress.ide.editors.text.tbp.PProtocol;
import eu.qimpress.ide.editors.text.tbp.PRepetition;
import eu.qimpress.ide.editors.text.tbp.PSequence;
import eu.qimpress.ide.editors.text.tbp.PTerm;
import eu.qimpress.ide.editors.text.tbp.ParameterDeclaration;
import eu.qimpress.ide.editors.text.tbp.Provision;
import eu.qimpress.ide.editors.text.tbp.RAssign;
import eu.qimpress.ide.editors.text.tbp.RCase;
import eu.qimpress.ide.editors.text.tbp.REvent;
import eu.qimpress.ide.editors.text.tbp.RIf;
import eu.qimpress.ide.editors.text.tbp.RReturn;
import eu.qimpress.ide.editors.text.tbp.RStatement;
import eu.qimpress.ide.editors.text.tbp.RSwitch;
import eu.qimpress.ide.editors.text.tbp.RSynchronized;
import eu.qimpress.ide.editors.text.tbp.RWhile;
import eu.qimpress.ide.editors.text.tbp.Reaction;
import eu.qimpress.ide.editors.text.tbp.TbpPackage;
import eu.qimpress.ide.editors.text.tbp.Type;
import eu.qimpress.ide.editors.text.tbp.TypeValue;
import eu.qimpress.ide.editors.text.tbp.Value;
import eu.qimpress.ide.editors.text.tbp.Variable;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see eu.qimpress.ide.editors.text.tbp.TbpPackage
 * @generated
 */
public class TbpSwitch<T>
{
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static TbpPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TbpSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = TbpPackage.eINSTANCE;
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  public T doSwitch(EObject theEObject)
  {
    return doSwitch(theEObject.eClass(), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(EClass theEClass, EObject theEObject)
  {
    if (theEClass.eContainer() == modelPackage)
    {
      return doSwitch(theEClass.getClassifierID(), theEObject);
    }
    else
    {
      List<EClass> eSuperTypes = theEClass.getESuperTypes();
      return
        eSuperTypes.isEmpty() ?
          defaultCase(theEObject) :
          doSwitch(eSuperTypes.get(0), theEObject);
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case TbpPackage.COMPONENT_BEHAVIOR_PROTOCOL:
      {
        ComponentBehaviorProtocol componentBehaviorProtocol = (ComponentBehaviorProtocol)theEObject;
        T result = caseComponentBehaviorProtocol(componentBehaviorProtocol);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.TYPE:
      {
        Type type = (Type)theEObject;
        T result = caseType(type);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.TYPE_VALUE:
      {
        TypeValue typeValue = (TypeValue)theEObject;
        T result = caseTypeValue(typeValue);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.VARIABLE:
      {
        Variable variable = (Variable)theEObject;
        T result = caseVariable(variable);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PROVISION:
      {
        Provision provision = (Provision)theEObject;
        T result = caseProvision(provision);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.REACTION:
      {
        Reaction reaction = (Reaction)theEObject;
        T result = caseReaction(reaction);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.THREAD:
      {
        eu.qimpress.ide.editors.text.tbp.Thread thread = (eu.qimpress.ide.editors.text.tbp.Thread)theEObject;
        T result = caseThread(thread);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.ANNOTATION:
      {
        Annotation annotation = (Annotation)theEObject;
        T result = caseAnnotation(annotation);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PPROTOCOL:
      {
        PProtocol pProtocol = (PProtocol)theEObject;
        T result = casePProtocol(pProtocol);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PALTERNATIVE:
      {
        PAlternative pAlternative = (PAlternative)theEObject;
        T result = casePAlternative(pAlternative);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PSEQUENCE:
      {
        PSequence pSequence = (PSequence)theEObject;
        T result = casePSequence(pSequence);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PAND_PARALLEL:
      {
        PAndParallel pAndParallel = (PAndParallel)theEObject;
        T result = casePAndParallel(pAndParallel);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.POR_PARALLEL:
      {
        POrParallel pOrParallel = (POrParallel)theEObject;
        T result = casePOrParallel(pOrParallel);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PREPETITION:
      {
        PRepetition pRepetition = (PRepetition)theEObject;
        T result = casePRepetition(pRepetition);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.AP_TERM:
      {
        APTerm apTerm = (APTerm)theEObject;
        T result = caseAPTerm(apTerm);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PTERM:
      {
        PTerm pTerm = (PTerm)theEObject;
        T result = casePTerm(pTerm);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PEVENT:
      {
        PEvent pEvent = (PEvent)theEObject;
        T result = casePEvent(pEvent);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.METHOD_NAME:
      {
        MethodName methodName = (MethodName)theEObject;
        T result = caseMethodName(methodName);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.METHOD_DECLARATION:
      {
        MethodDeclaration methodDeclaration = (MethodDeclaration)theEObject;
        T result = caseMethodDeclaration(methodDeclaration);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.BLOCK:
      {
        Block block = (Block)theEObject;
        T result = caseBlock(block);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.IMPERATIVE:
      {
        Imperative imperative = (Imperative)theEObject;
        T result = caseImperative(imperative);
        if (result == null) result = caseBlock(imperative);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.AR_STATEMENT:
      {
        ARStatement arStatement = (ARStatement)theEObject;
        T result = caseARStatement(arStatement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RSTATEMENT:
      {
        RStatement rStatement = (RStatement)theEObject;
        T result = caseRStatement(rStatement);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RSWITCH:
      {
        RSwitch rSwitch = (RSwitch)theEObject;
        T result = caseRSwitch(rSwitch);
        if (result == null) result = caseRStatement(rSwitch);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RCASE:
      {
        RCase rCase = (RCase)theEObject;
        T result = caseRCase(rCase);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RWHILE:
      {
        RWhile rWhile = (RWhile)theEObject;
        T result = caseRWhile(rWhile);
        if (result == null) result = caseRStatement(rWhile);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RIF:
      {
        RIf rIf = (RIf)theEObject;
        T result = caseRIf(rIf);
        if (result == null) result = caseRStatement(rIf);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RSYNCHRONIZED:
      {
        RSynchronized rSynchronized = (RSynchronized)theEObject;
        T result = caseRSynchronized(rSynchronized);
        if (result == null) result = caseRStatement(rSynchronized);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.REVENT:
      {
        REvent rEvent = (REvent)theEObject;
        T result = caseREvent(rEvent);
        if (result == null) result = caseRStatement(rEvent);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RASSIGN:
      {
        RAssign rAssign = (RAssign)theEObject;
        T result = caseRAssign(rAssign);
        if (result == null) result = caseREvent(rAssign);
        if (result == null) result = caseRStatement(rAssign);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.VALUE:
      {
        Value value = (Value)theEObject;
        T result = caseValue(value);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.RRETURN:
      {
        RReturn rReturn = (RReturn)theEObject;
        T result = caseRReturn(rReturn);
        if (result == null) result = caseREvent(rReturn);
        if (result == null) result = caseRStatement(rReturn);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.CONDITION:
      {
        Condition condition = (Condition)theEObject;
        T result = caseCondition(condition);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.METHOD_CALL:
      {
        MethodCall methodCall = (MethodCall)theEObject;
        T result = caseMethodCall(methodCall);
        if (result == null) result = caseREvent(methodCall);
        if (result == null) result = caseValue(methodCall);
        if (result == null) result = caseRStatement(methodCall);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case TbpPackage.PARAMETER_DECLARATION:
      {
        ParameterDeclaration parameterDeclaration = (ParameterDeclaration)theEObject;
        T result = caseParameterDeclaration(parameterDeclaration);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Component Behavior Protocol</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Component Behavior Protocol</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseComponentBehaviorProtocol(ComponentBehaviorProtocol object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseType(Type object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Type Value</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Type Value</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseTypeValue(TypeValue object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Variable</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Variable</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseVariable(Variable object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Provision</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Provision</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseProvision(Provision object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Reaction</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Reaction</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseReaction(Reaction object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Thread</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Thread</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseThread(eu.qimpress.ide.editors.text.tbp.Thread object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Annotation</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Annotation</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAnnotation(Annotation object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PProtocol</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PProtocol</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePProtocol(PProtocol object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PAlternative</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PAlternative</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePAlternative(PAlternative object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PSequence</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PSequence</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePSequence(PSequence object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PAnd Parallel</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PAnd Parallel</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePAndParallel(PAndParallel object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>POr Parallel</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>POr Parallel</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePOrParallel(POrParallel object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PRepetition</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PRepetition</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePRepetition(PRepetition object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>AP Term</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>AP Term</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAPTerm(APTerm object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PTerm</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PTerm</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePTerm(PTerm object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>PEvent</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>PEvent</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T casePEvent(PEvent object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Method Name</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Method Name</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMethodName(MethodName object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Method Declaration</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Method Declaration</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMethodDeclaration(MethodDeclaration object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Block</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Block</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseBlock(Block object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Imperative</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Imperative</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseImperative(Imperative object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>AR Statement</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>AR Statement</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseARStatement(ARStatement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RStatement</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RStatement</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRStatement(RStatement object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RSwitch</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RSwitch</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRSwitch(RSwitch object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RCase</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RCase</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRCase(RCase object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RWhile</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RWhile</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRWhile(RWhile object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RIf</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RIf</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRIf(RIf object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RSynchronized</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RSynchronized</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRSynchronized(RSynchronized object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>REvent</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>REvent</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseREvent(REvent object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RAssign</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RAssign</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRAssign(RAssign object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Value</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Value</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseValue(Value object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>RReturn</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>RReturn</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseRReturn(RReturn object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Condition</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Condition</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseCondition(Condition object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Method Call</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Method Call</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseMethodCall(MethodCall object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Parameter Declaration</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Parameter Declaration</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseParameterDeclaration(ParameterDeclaration object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  public T defaultCase(EObject object)
  {
    return null;
  }

} //TbpSwitch
