package eu.qimpress.ide.editors.text.validation;

import java.util.List;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

import eu.qimpress.samm.core.CorePackage;
import eu.qimpress.samm.core.NamedEntity;
 

public class EdificeJavaValidator extends AbstractEdificeJavaValidator {

//	@Check
//	public void checkTypeNameStartsWithCapital(Type type) {
//		if (!Character.isUpperCase(type.getName().charAt(0))) {
//			warning("Name should start with a capital", MyDslPackage.TYPE__NAME);
//		}
//	}
	@Check(CheckType.FAST)
	public void checkEntityNameAvoidingSpaces(NamedEntity entity) {
		if (entity.getName().contains(" ")) {
			error("Entity's name cannot contain space", CorePackage.NAMED_ENTITY__NAME);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
		protected List<? extends EPackage> getEPackages() {
			List<EPackage> result = (List<EPackage>) super.getEPackages();
			
			result.add(CorePackage.eINSTANCE);
			return result;
		}

}
