/*
 * generated by Xtext
 */
package eu.qimpress.ide.editors.text.scoping;

import static com.google.common.collect.Iterables.filter;
import static com.google.common.collect.Iterables.transform;

import java.util.Iterator;

import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.index.IQualifiedNameProvider;
import org.eclipse.xtext.linking.impl.SimpleAttributeResolver;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopedElement;
import org.eclipse.xtext.scoping.impl.AbstractScopeProvider;
import org.eclipse.xtext.scoping.impl.ScopedElement;
import org.eclipse.xtext.scoping.impl.SimpleScope;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditor;


/**
 * This class contains custom scoping description.
 * 
 * see : http://wiki.eclipse.org/Xtext/Documentation#Scoping
 * on how and when to use it 
 *
 */
public class EdificeScopeProvider extends AbstractScopeProvider {
//public class EdificeScopeProvider extends IndexBasedQualifiedNameScopeProvider {
	SimpleAttributeResolver<EObject, String> nameResolver = SimpleAttributeResolver.newResolver(String.class, "name");
	
	@Inject
	private IQualifiedNameProvider nameProvider;

	public void setNameProvider(IQualifiedNameProvider nameProvider) {
		this.nameProvider = nameProvider;
	}
	
	@Override
	public IScope getScope(EObject context, EReference reference) {
		if (reference != null) {
			return getScope(context, reference.getEReferenceType());
		} else {
			return IScope.NULLSCOPE;
		}
	}
	
	/**
	 * Return global scope for the given context. It includes the demanded objects of all
	 * models stored in the default alternative
	 * 
	 * @param context 
	 * @param type element type to look for
	 * @return filled scope
	 */
	protected IScope getGlobalScope(final EObject context, final EClass type) {
		IScope parent = IScope.NULLSCOPE;
		if (context.eResource() == null || context.eResource().getResourceSet() == null)
			return parent;

		// Q-I specific part
		try {
			// get resource set of the default alternative
			IProject project = QImpressCore.getProject(context.eResource().getURI());
			IQProject qProject = QImpressApplicationModelManager.getManager().getQAppModel().getQProject(project);
			IQAlternative qAlternative = qProject.getRepository().getDefaultAlternative();
			ShadowModelEditor shadowModelEditor = (ShadowModelEditor) qAlternative.getAdapter(ShadowModelEditor.class);			
			ResourceSet qImpressResourceSet = shadowModelEditor.getEditingDomain().getResourceSet();
			
			// create scope
			parent = createScopeWithQualifiedNames(parent, type, allEObjects(qImpressResourceSet));
		} catch (RepositoryException e) {};		
		
		return parent;
	}
	
	private Iterable<EObject> allEObjects(final ResourceSet resourceSet) {
		Iterable<EObject> contents = new Iterable<EObject>() {
			public Iterator<EObject> iterator() {
				return EcoreUtil.getAllProperContents(resourceSet, true);
			}
		};
		Iterable<EObject> filtered = Iterables.filter(contents, EObject.class);
		return filtered;
	}
	
	protected IScope createScopeWithQualifiedNames(final IScope parent, final EClass type, Iterable<EObject> eObjects) {

		eObjects = filter(eObjects, typeFilter(type));

		Iterable<IScopedElement> result = transform(eObjects, new Function<EObject, IScopedElement>() {

			public IScopedElement apply(EObject from) {
				String qualifiedName = nameProvider.getQualifiedName(from);
				if (qualifiedName != null) {
					return ScopedElement.create(qualifiedName, from);
				}
				return null;
			}
		});
		
		return new SimpleScope(parent, filter(result, Predicates.notNull()));
	}
	
	protected Predicate<EObject> typeFilter(final EClass type) {
		return new Predicate<EObject>() {

			public boolean apply(EObject input) {
				return type.isInstance(input);
			}
		};
	}

	/**
	 * Look for local elements of the given type in the specified context.
	 * 
	 * @param context context where to look for the elements of the given type
	 * @param type type of required elements
	 * @return list of scoped elements
	 */
	@SuppressWarnings("unchecked")
	protected Iterable<IScopedElement> getLocalElements(final EObject context, final EClass type) {
		final String commonPrefix = nameProvider.getQualifiedName(context) + nameProvider.getDelimiter();		
		
		Iterable<? extends EObject> contents = new Iterable<EObject>() {
			public Iterator<EObject> iterator() {
				TreeIterator<EObject> ti = EcoreUtil.getAllProperContents(context, true);
				return (Iterator<EObject>) ti;
			}			
		};
		
		// filter by type
		contents = filter(contents, typeFilter(type));
		
		// transform to IScopedElements
		Iterable<IScopedElement> scopedElements = transform(contents, new Function<EObject, IScopedElement>() {

			public IScopedElement apply(EObject from) {
				String name = nameProvider.getQualifiedName(from);
				if (name != null && name.startsWith(commonPrefix))
					return ScopedElement.create(name.substring(commonPrefix.length()), from);
				return null;
			}

		});
		// filter null values;
		return filter(scopedElements, Predicates.notNull());			
	}

	
	@Override
	public IScope getScope(final EObject context, final EClass type) {
		IScope result = null;
		
		if (context!=null) {
			if (context.eContainer() == null) {
				// global scope - models stored in default alternative
				result = getGlobalScope(context, type);
			} else {
				// outer scope in XText file
				result = getScope(context.eContainer(), type);
			}
		}
		
		// local scope
		if (context.eContainer() != null && nameProvider.getQualifiedName(context) != null) {
			Iterable<IScopedElement> localElements = getLocalElements(context, type);
			result = new SimpleScope(result, localElements);
		}
		
		return result;
	}	
}
