/**
 * 
 */
package eu.qimpress.ide.editors.text.resource;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.parsetree.reconstr.impl.DefaultTransientValueService;

import de.uka.ipd.sdq.stoex.StoexPackage;
import eu.qimpress.samm.deployment.hardware.HardwarePackage;
import eu.qimpress.samm.qosannotation.QosannotationPackage;
import eu.qimpress.samm.staticstructure.StaticstructurePackage;
import eu.qimpress.samm.usagemodel.UsagemodelPackage;

/**
 * Avoid serialization of selected structural features.
 * 
 * Some features do not need to be serialized because they hold information
 * already included in the model (e.g., inverse end-points of references, collections)
 * 
 * @author Michal Malohlava
 *
 */
public class EdificeTransientValueService extends DefaultTransientValueService {
		
	public static final EStructuralFeature[] TRANSIENT_FEATURES = {
//		IdentifierPackage.Literals.IDENTIFIER__ID, // cannot not serialize because ID of the 
		HardwarePackage.Literals.PROCESSOR_CORE__CACHES,
		HardwarePackage.Literals.PROCESSOR_CORE__DESCRIPTOR,
		StaticstructurePackage.Literals.INTERFACE_PORT__PROVIDING_COMPONENT_TYPE,
		StaticstructurePackage.Literals.INTERFACE_PORT__REQUIRING_COMPONENT_TYPE,
		StaticstructurePackage.Literals.INTERFACE_PORT__IS_REQUIRED,
		StaticstructurePackage.Literals.EVENT_PORT__IS_SOURCE,
		StaticstructurePackage.Literals.CONNECTOR__IS_DELEGATION,		
		UsagemodelPackage.Literals.WORKLOAD__USAGE_SCENARIO,
		
		QosannotationPackage.Literals.ANNOTATION__QOS_ANNOTATIONS,
		StoexPackage.Literals.RANDOM_VARIABLE__EXPRESSION
	};
		
	@Override
	public boolean isTransient(EObject owner, EStructuralFeature feature, int index) {		
		return super.isTransient(owner, feature, index) || feature.isDerived()
				|| match(owner, feature);
	}
	
	protected boolean match(EObject owner, EStructuralFeature feature) {
		for (int i = 0; i < TRANSIENT_FEATURES.length; i++) {
			if (feature == TRANSIENT_FEATURES[i]) 
				return true;
		}
				
		return false;				
	}

}
