/**
 * 
 */
package eu.qimpress.ide.editors.text.linking;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopedElement;

/**
 * Q-ImPrESS specific linking service.
 * 
 * If the linked element is not found by default linking service, it tries to compare
 * IDs of proposed elements and find the right one.
 * 
 * @author Michal Malohlava
 *
 */
public class EdificeLinkingService extends DefaultLinkingService {
	
	@Override
	protected String getUnconvertedLinkText(EObject object,
			EReference reference, EObject context) {
		String linkText = super.getUnconvertedLinkText(object, reference, context);
		
		if (linkText == null) {
			IScope scope = getScopeProvider().getScope(context, reference);
			if (scope == null)
				return null;
			IScopedElement scopedElement = getScopedElementById(scope,object);
			if (scopedElement != null) {
				linkText = scopedElement.name();
			}						
		}
		
		return linkText;
	}

	private IScopedElement getScopedElementById(IScope scope, EObject element) {
		Iterable<IScopedElement> allContents = scope.getAllContents();
		String leftID = EcoreUtil.getID(element);
		for (IScopedElement scopedElement : allContents) {
			String rightID = EcoreUtil.getID(scopedElement.element());
			if (leftID!=null && leftID.equals(rightID))
				return scopedElement;
		}
		return null;
	}

}
