/*
 * generated by Xtext
 */
package eu.qimpress.ide.editors.text.formatting;

import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.IGrammarAccess.IParserRuleAccess;
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter;
import org.eclipse.xtext.formatting.impl.FormattingConfig;

/**
 * This class contains custom formatting description.
 * 
 * This class uses reflection to format code - put break after each semicolon and left curly bracket
 * and indent content between two curly brackets;
 * 
 * TODO improvement - it would be better to generate this class directly according to grammar using e.g. Acceleo
 * 
 */
public class EdificeFormatter extends AbstractDeclarativeFormatter {
	private static final Logger logger = Logger.getLogger(EdificeFormatter.class);
	
	@Override
	protected void configureFormatting(FormattingConfig c) {
		eu.qimpress.ide.editors.text.services.EdificeGrammarAccess f = (eu.qimpress.ide.editors.text.services.EdificeGrammarAccess) getGrammarAccess();
		
		c.setAutoLinewrap(120);
		
		List<Method> accessMethods = getMethodsByPattern(f, "Access");
		Object[] parserRuleElementFinders = getResultsByCallingMethods(f, accessMethods);
				
		for(Object o : parserRuleElementFinders) {			
			if (o instanceof IParserRuleAccess) {
				IParserRuleAccess ruleElementFinder = (IParserRuleAccess) o;
				// add new line after each semicolon
				addNewlineAfterEachRuleByPattern(c, ruleElementFinder, "SemicolonKeyword");
				
				// add new line after each left curly bracket
				addNewlineAfterEachRuleByPattern(c, ruleElementFinder, "LeftCurlyBracketKeyword");
				
				// add new line after each right curly bracket
				addNewlineAfterEachRuleByPattern(c, ruleElementFinder, "RightCurlyBracketKeyword");
				
				addIndentation(c, ruleElementFinder, "LeftCurlyBracketKeyword", "RightCurlyBracketKeyword");
			}	
		}
	}
	
	protected <T> void addIndentation(FormattingConfig c, T target, String topPattern, String bottomPattern) {
		List<Method> topIndentMethods = getMethodsByPattern(target, topPattern);
		List<Method> bottomIndentMethods = getMethodsByPattern(target, bottomPattern);
		
		if (topIndentMethods.size() == bottomIndentMethods.size()) {
			int size = topIndentMethods.size();
			for (int i = 0; i < size; i++) {
				try {
					c.setIndentation((AbstractElement) topIndentMethods.get(i).invoke(target), (AbstractElement) bottomIndentMethods.get(i).invoke(target));
				} catch (Exception e) {					
					logger.warn("Cannot invoke methods on " + target);
				}
			}
		}
		
	}

	protected <T> void addNewlineAfterEachRuleByPattern(FormattingConfig c, T target, String pattern) {
		List<Method> semicolonMethods = getMethodsByPattern(target, pattern);
		
		for (Method m : semicolonMethods) {
			try {
				c.setLinewrap().after((EObject) m.invoke(target));
			} catch (Exception e) {					
				logger.warn("Cannot invoke method " + m + " on " + target);
			}
		}		
	}
	
	protected <R,T> R[] getResultsByCallingMethods(T f, List<Method> methods) {
		List<R> results = new LinkedList<R>();
		
		for(Method m : methods) {
			try {
				R r = (R) m.invoke(f);				
				results.add(r);
			} catch (Exception e) {
				logger.warn("Cannot invoke method " + m + " on " + f);
			}			
		}		
		// filter by result type
		return (R[]) results.toArray();
	}

	protected <T> List<Method> getMethodsByPattern(T f, String pattern) {
		List<Method> methods = new LinkedList<Method>();
		
		Method[] allMethods = f.getClass().getMethods();
		for (Method m : allMethods) {
			if (m.getName().contains(pattern)) {
				methods.add(m);				
			}
		}
		
		return methods;
	}
}
