/**
 * 
 */
package eu.qimpress.ide.editors.text.conversion;

import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.util.Strings;

/**
 * Provides value converter for Double values.
 * 
 * @author Michal Malohlava
 *
 */
public class EdificeValueConverterService extends DefaultTerminalConverters {
	
	@ValueConverter(rule = "DOUBLE")
	public IValueConverter<Double> DOUBLE() {
		return new IValueConverter<Double>() {

			@Override
			public String toString(Double value) {
				return value.toString();
			}

			@Override
			public Double toValue(String string, AbstractNode node)
					throws ValueConverterException {
				if (Strings.isEmpty(string))
					throw new ValueConverterException("Couldn't convert empty string to double", node, null);
				try {
					return Double.valueOf(string);
				} catch (NumberFormatException e) {
					throw new ValueConverterException("Couldn't convert '"+string+"' to int", node, e);
				}
			}
		};		
		
	}

}
