/**
 * 
 */
package eu.qimpress.ide.editors.text.highlighting;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.common.editor.syntaxcoloring.ISemanticHighlightingCalculator;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.samm.core.NamedEntity;

/**
 * Semantic highlighter for Edifice language.
 * 
 * @author Michal Malohlava
 * 
 */
public class EdificeSemanticHighlightingCalculator implements
		ISemanticHighlightingCalculator {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.xtext.ui.common.editor.syntaxcoloring.ISemanticHighlightingCalculator#provideHighlightingFor(org.eclipse.xtext.resource.XtextResource,
	 * org.eclipse
	 * .xtext.ui.common.editor.syntaxcoloring.IHighlightedPositionAcceptor)
	 */
	@Override
	public void provideHighlightingFor(XtextResource resource,
			IHighlightedPositionAcceptor acceptor) {

		if (resource == null)
			return;

		List<EObject> content = EcoreUtil2.eAllContentsAsList(resource);
		// mark ID features		
		List<Identifier> elementsWithId = EcoreUtil2.typeSelect(content,
				Identifier.class);
		markFeature(elementsWithId, "id", EdificeSemanticHighlightingConfig.IDENTIFIER_ID, acceptor);
		
		// mark name features
		List<NamedEntity> elementsWithName = EcoreUtil2.typeSelect(content, NamedEntity.class);
		markFeature(elementsWithName, "name", EdificeSemanticHighlightingConfig.NAMED_ENTITY_NAME, acceptor);
		
		// mark cross reference
		Iterable<AbstractNode> allNodes = NodeUtil.getAllContents(resource.getParseResult().getRootNode());
		for (AbstractNode abstractNode : allNodes) {
			if (abstractNode.getGrammarElement() instanceof CrossReference) {
				if (abstractNode.getLength() > 0) {
					acceptor.addPosition(abstractNode.getOffset(), abstractNode.getLength(), EdificeSemanticHighlightingConfig.CROSS_REFS);
				}
			}
		}
	}
	
	protected void markFeature(Collection<? extends EObject> elements, String featureName, String highlightConfigID, IHighlightedPositionAcceptor acceptor) {
		for (EObject element : elements) {
			LeafNode node = getFirstFeatureNode(element, featureName);
			if (node != null) {
				if (node.getLength() > 0) {
					acceptor.addPosition(node.getOffset(), node.getLength(), highlightConfigID);
				}
			}
		}		
	}

	protected LeafNode getFirstFeatureNode(EObject semantic, String feature) {
		NodeAdapter adapter = NodeUtil.getNodeAdapter(semantic);
		if (adapter != null) {
			CompositeNode node = adapter.getParserNode();
			if (node != null) {
				if (feature == null)
					return null;
				for (AbstractNode child : node.getChildren()) {
					if (child instanceof LeafNode) {
						if (feature.equals(((LeafNode) child).getFeature())) {
							return (LeafNode) child;
						}
					}
				}
			}
		}
		return null;
	}

}
