package eu.qimpress.ide.editors.gmf.seff.part;

import java.util.Enumeration;
import java.util.Vector;

import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.Repository;

public class SeffNewDiagramFileBlackboard {

	private Repository repository = null;
	private Operation operation = null;
	private ComponentType component = null;
	private String filename = null;

	public String getFilename() {
		return filename;
	}

	public void setFilename(String filename) {
		if (filename == null) {
			if (this.filename != null) {
				this.filename = filename;
				fireFilenameChanged();
			}
			return;
		}
		if (!filename.equals(this.filename)) {
			this.filename = filename;
			fireFilenameChanged();
		}
	}

	public ComponentType getComponent() {
		return component;
	}

	public void setComponent(ComponentType component) {
		if (component == null) {
			if (this.component != null) {
				this.component = component;
				fireComponentChanged();
			}
			return;
		}
		if (!component.equals(this.component)) {
			this.component = component;
			fireComponentChanged();
		}
	}

	public Operation getOperation() {
		return operation;
	}

	public void setOperation(Operation operation) {
		this.operation = operation;
	}

	public Repository getRepository() {
		return repository;
	}

	public void setRepository(Repository repository) {
		if (repository == null) {
			if (this.repository != null) {
				this.repository = repository;
				fireRepositoryChanged();
			}
			return;
		}
		if (!repository.equals(this.repository)) {
			this.repository = repository;
			fireRepositoryChanged();
		}
	}

	public SeffNewDiagramFileBlackboard() {

	}

	//
	// Event handling
	//

	private transient Vector<BlackboardListener> blackboardListeners;

	/** Register a listener for MasterModel events */
	synchronized public void addBlackboardListener(BlackboardListener listener) {
		if (blackboardListeners == null) {
			blackboardListeners = new Vector<BlackboardListener>();
		}
		blackboardListeners.addElement(listener);
	}

	synchronized public void removeBlackboardListener(
			BlackboardListener listener) {
		if (blackboardListeners == null) {
			blackboardListeners = new Vector<BlackboardListener>();
		}
		blackboardListeners.removeElement(listener);
	}

	/** Fire to all registered listeners */
	@SuppressWarnings("unchecked")
	public void fireComponentChanged() {
		// If we have no listeners, do nothing.
		if ((blackboardListeners != null) && !blackboardListeners.isEmpty()) {

			// Make a copy of the listener list in case anyone adds or removes
			// listeners.
			Vector<BlackboardListener> targets;
			synchronized (blackboardListeners) {
				targets = (Vector<BlackboardListener>) blackboardListeners
						.clone();
			}

			// Walk through the listener list and call the listener method in
			// each.
			Enumeration<BlackboardListener> e = targets.elements();
			while (e.hasMoreElements()) {
				BlackboardListener l = (BlackboardListener) e.nextElement();
				l.componentChanged();
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	public void fireFilenameChanged() {
		// If we have no listeners, do nothing.
		if ((blackboardListeners != null) && !blackboardListeners.isEmpty()) {

			// Make a copy of the listener list in case anyone adds or removes
			// listeners.
			Vector<BlackboardListener> targets;
			synchronized (blackboardListeners) {
				targets = (Vector<BlackboardListener>) blackboardListeners
						.clone();
			}

			// Walk through the listener list and call the listener method in
			// each.
			Enumeration<BlackboardListener> e = targets.elements();
			while (e.hasMoreElements()) {
				BlackboardListener l = (BlackboardListener) e.nextElement();
				l.filenameChanged();
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	public void fireRepositoryChanged() {
		// If we have no listeners, do nothing.
		if ((blackboardListeners != null) && !blackboardListeners.isEmpty()) {

			// Make a copy of the listener list in case anyone adds or removes
			// listeners.
			Vector<BlackboardListener> targets;
			synchronized (blackboardListeners) {
				targets = (Vector<BlackboardListener>) blackboardListeners
						.clone();
			}

			// Walk through the listener list and call the listener method in
			// each.
			Enumeration<BlackboardListener> e = targets.elements();
			while (e.hasMoreElements()) {
				BlackboardListener l = (BlackboardListener) e.nextElement();
				l.repositoryChanged();
			}
		}
	}

}
