package eu.qimpress.ide.editors.gmf.seff.part;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;

import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingSEFFEditPart;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;

/**
 * @author wsa
 *
 */
public class SeffInitDiagramFileForEObjectAction implements IObjectActionDelegate {

	private ResourceDemandingSEFF seff;
	private IWorkbenchPart targetPart;

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction, org.eclipse.ui.IWorkbenchPart)
	 */
	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.targetPart = targetPart;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {
		TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
		ResourceSet resourceSet = editingDomain.getResourceSet();
		resourceSet.getResource(seff.eResource().getURI(), true);
		createDiagramFromEObject(seff.eResource().getURI(), seff, editingDomain);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		action.setEnabled(false);
		if (selection instanceof IStructuredSelection == false
				|| selection.isEmpty()) {
			return;
		}
		seff = (ResourceDemandingSEFF) ((IStructuredSelection) selection).getFirstElement();
		action.setEnabled(true);
	}
	
	private Shell getShell() {
		return targetPart.getSite().getShell();
	}
	
	private void createDiagramFromEObject(URI domainModelURI, final ResourceDemandingSEFF diagramRoot,
			TransactionalEditingDomain editingDomain) {
		
		String stub_id = "";
		if (diagramRoot.getSeffBehaviourStub() != null) {
			stub_id = diagramRoot.getSeffBehaviourStub().getId();
		} else {
			stub_id = Integer.toString(((SeffRepository)(diagramRoot.eContainer())).getResourceDemandingSeff().indexOf(diagramRoot));
		}
		URI diagramModelURI = domainModelURI.trimSegments(1).appendSegment(
				domainModelURI.trimFileExtension().lastSegment() + "_" +
				"seff" + stub_id +
				".samm_seff_diagram");
		ResourceSet resourceSet = editingDomain.getResourceSet();
		final Resource diagramResource = resourceSet.createResource(diagramModelURI);
		
		List affectedFiles = new LinkedList();
		String platformString = diagramModelURI.toPlatformString(true);
		IFile diagramFile = (IFile) ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
		SeffDiagramEditorUtil.setCharset(diagramFile);
		affectedFiles.add(diagramFile);
		
		AbstractTransactionalCommand command = new AbstractTransactionalCommand(
				editingDomain,
				Messages.SeffNewDiagramFileWizard_InitDiagramCommand,
				affectedFiles) {

			protected CommandResult doExecuteWithResult(
					IProgressMonitor monitor, IAdaptable info)
					throws ExecutionException {
				Diagram diagram = ViewService.createDiagram(
						diagramRoot,
						ResourceDemandingSEFFEditPart.MODEL_ID,
						SeffDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
				diagramResource.getContents().add(diagram);
				return CommandResult.newOKCommandResult();
			}
		};
		try {
			OperationHistoryFactory.getOperationHistory().execute(command,
					new NullProgressMonitor(), null);
			diagramResource.save(SeffDiagramEditorUtil.getSaveOptions());
			SeffDiagramEditorUtil.openDiagram(diagramResource);
		} catch (ExecutionException e) {
			SeffDiagramEditorPlugin.getInstance().logError(
					"Unable to create model and diagram", e); //$NON-NLS-1$
		} catch (IOException ex) {
			SeffDiagramEditorPlugin.getInstance().logError(
					"Save operation failed for: " + diagramModelURI, ex); //$NON-NLS-1$
		} catch (PartInitException ex) {
			SeffDiagramEditorPlugin.getInstance().logError(
					"Unable to open editor", ex); //$NON-NLS-1$
		}
	}
}

