package eu.qimpress.ide.editors.gmf.seff.part;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingSEFFEditPart;
import eu.qimpress.samm.behaviour.BehaviourFactory;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.seffFactory;
import eu.qimpress.seff.impl.SeffRepositoryImpl;

public class SeffAddSeffWizard extends Wizard {

	private WizardNewFileCreationPage myFileCreationPage;

	private RepositorySelectorPage myRepositorySelectorPage;
	private ComponentSelectorPage myComponentSelectorPage;
	private OperationSelectorPage myOperationSelectorPage;
	private SeffNewDiagramFileBlackboard blackboard;

	private TransactionalEditingDomain myEditingDomain;

	private SeffRepository myDiagramRoot = null;;
	private URI domainModelURI = null;

	public SeffAddSeffWizard(URI domainModelURI, EObject diagramRoot,
			TransactionalEditingDomain editingDomain) {
		assert domainModelURI != null : "Domain model uri must be specified"; //$NON-NLS-1$
		assert diagramRoot != null : "Diagram root element must be specified"; //$NON-NLS-1$
		assert diagramRoot instanceof SeffRepositoryImpl : "Root element must be a Seff Repository!";
		assert editingDomain != null : "Editing domain must be specified"; //$NON-NLS-1$
				
		if (diagramRoot instanceof SeffRepositoryImpl) {
			myDiagramRoot = (SeffRepository) diagramRoot;
		}
		this.domainModelURI = domainModelURI;
		myEditingDomain = editingDomain;

		
	}
	
	private void preparePages() {
		blackboard = new SeffNewDiagramFileBlackboard();
		blackboard.addBlackboardListener(new BlackboardListener() {
			public void componentChanged() {}

			public void filenameChanged() {
				myFileCreationPage.setFileName(blackboard.getFilename());
			}

			public void repositoryChanged() {}
		});

		

		myRepositorySelectorPage = new RepositorySelectorPage(myDiagramRoot,
				blackboard);
		myComponentSelectorPage = new ComponentSelectorPage(myDiagramRoot,
				blackboard);
		myOperationSelectorPage = new OperationSelectorPage(myDiagramRoot, "Select operation",
				blackboard);
		
		myFileCreationPage = new WizardNewFileCreationPage(
				Messages.SeffNewDiagramFileWizard_CreationPageName,
				StructuredSelection.EMPTY);
		myFileCreationPage
				.setTitle(Messages.SeffNewDiagramFileWizard_CreationPageTitle);
		myFileCreationPage.setDescription(NLS.bind(
				Messages.SeffNewDiagramFileWizard_CreationPageDescription,
				ResourceDemandingSEFFEditPart.MODEL_ID));
		IPath filePath;
		String fileName = URI.decode(domainModelURI.trimFileExtension()
				.lastSegment());
		if (domainModelURI.isPlatformResource()) {
			filePath = new Path(domainModelURI.trimSegments(1)
					.toPlatformString(true));
		} else if (domainModelURI.isFile()) {
			filePath = new Path(domainModelURI.trimSegments(1).toFileString());
		} else {
			// TODO : use some default path
			throw new IllegalArgumentException(
					"Unsupported URI: " + domainModelURI); //$NON-NLS-1$
		}
		
		myFileCreationPage.setContainerFullPath(filePath);
		myFileCreationPage.setFileName(SeffDiagramEditorUtil.getUniqueFileName(
				filePath, fileName, "samm_seff_diagram")); //$NON-NLS-1$

	}
	
	public void addPages() {
		preparePages();
		if (myRepositorySelectorPage.getSelectedRepository() == null) {
			addPage(myRepositorySelectorPage);
		}
		addPage(myComponentSelectorPage);
		addPage(myOperationSelectorPage);
		addPage(myFileCreationPage);
	}

	public boolean performFinish() {
		List affectedFiles = new LinkedList();
		IFile diagramFile = myFileCreationPage.createNewFile();
		SeffDiagramEditorUtil.setCharset(diagramFile);
		affectedFiles.add(diagramFile);
		
		// This does not work! Diagram cannot be created then
		//String fileString = URI.decode(blackboard.getRepository().eResource().getURI().path());
		//IFile repositoryFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(fileString));
		//affectedFiles.add(repositoryFile);
		
		URI diagramModelURI = URI.createPlatformResourceURI(diagramFile
				.getFullPath().toString(), true);
		ResourceSet resourceSet = myEditingDomain.getResourceSet();

		final Resource diagramResource = resourceSet
				.createResource(diagramModelURI);
		
		AbstractTransactionalCommand firstCommand = new AbstractTransactionalCommand(
				myEditingDomain,
				Messages.SeffNewDiagramFileWizard_InitDiagramCommand,
				affectedFiles) {
			protected CommandResult doExecuteWithResult(
					IProgressMonitor monitor, IAdaptable info)
			throws ExecutionException {
				myEditingDomain.loadResource(blackboard.getComponent().eResource().getURI().toString());
				return CommandResult.newOKCommandResult();
			}
		};
		
		AbstractTransactionalCommand command = new AbstractTransactionalCommand(
				myEditingDomain,
				Messages.SeffNewDiagramFileWizard_InitDiagramCommand,
				affectedFiles) {

			protected CommandResult doExecuteWithResult(
					IProgressMonitor monitor, IAdaptable info)
					throws ExecutionException {
				ResourceDemandingSEFF seff = seffFactory.eINSTANCE
						.createResourceDemandingSEFF();
				SeffBehaviourStub stub = null;
				System.out.println("Is component read only: " + myEditingDomain.isReadOnly(blackboard.getComponent().eResource()));
				System.out.println("Repo resource set: " + blackboard.getComponent().eResource().getURI().toString());
//				myEditingDomain.loadResource(blackboard.getComponent().eResource().getURI().toString());
				for (Resource resources : myEditingDomain.getResourceSet().getResources()) {
					System.out.println("Resource URI: " + resources.getURI().toString() + ", " + myEditingDomain.isReadOnly(resources));
				}
				if (myEditingDomain.isReadOnly(myDiagramRoot.eResource())) {
					System.out.println("Cannot write to SEFF repository!");
				}
				for (OperationBehaviour behaviour : blackboard.getComponent().getOperationBehaviour()) {
					if (behaviour instanceof SeffBehaviourStub) {
						if (behaviour.getOperation().equals(blackboard.getOperation())) {
							stub = (SeffBehaviourStub)behaviour;
							break;
						}
					}
				}
				if (stub == null) {
					stub = BehaviourFactory.eINSTANCE.createSeffBehaviourStub();
					stub.setOperation(blackboard.getOperation());					
					//stub did not exist before: add to component
					blackboard.getComponent().getOperationBehaviour().add(stub);
				}
				seff.setSeffBehaviourStub(stub);
				myDiagramRoot.getResourceDemandingSeff().add(seff);

				try {
					myDiagramRoot.eResource().save(null);
					blackboard.getComponent().eResource().save(null);
				} catch (IOException e) {
					return CommandResult
					.newErrorCommandResult(Messages.SeffCreationWizardCreationError);
				}
				int diagramVID = SeffVisualIDRegistry.getDiagramVisualID(seff);
				if (diagramVID != ResourceDemandingSEFFEditPart.VISUAL_ID) {
					return CommandResult
							.newErrorCommandResult(Messages.SeffNewDiagramFileWizard_IncorrectRootError);
				}
				Diagram diagram = ViewService.createDiagram(seff,
						ResourceDemandingSEFFEditPart.MODEL_ID,
						SeffDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
				diagramResource.getContents().add(diagram);
				return CommandResult.newOKCommandResult();
			}
		};
		try {
			OperationHistoryFactory.getOperationHistory().execute(firstCommand,
					new NullProgressMonitor(), null);
			OperationHistoryFactory.getOperationHistory().execute(command,
					new NullProgressMonitor(), null);
			diagramResource.save(SeffDiagramEditorUtil.getSaveOptions());
			SeffDiagramEditorUtil.openDiagram(diagramResource);
		} catch (ExecutionException e) {
			SeffDiagramEditorPlugin.getInstance().logError(
					"Unable to create model and diagram", e); //$NON-NLS-1$
		} catch (IOException ex) {
			SeffDiagramEditorPlugin.getInstance().logError(
					"Save operation failed for: " + diagramModelURI, ex); //$NON-NLS-1$
		} catch (PartInitException ex) {
			SeffDiagramEditorPlugin.getInstance().logError(
					"Unable to open editor", ex); //$NON-NLS-1$
		}
		return true;
	}

}
