package eu.qimpress.ide.editors.gmf.seff.part;

import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.impl.ComponentTypeImpl;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;

/**
 * This wizard page uses the regular resource selector page, but checks the type
 * of the resource selected by the user to be a Repository.
 */
class RepositorySelectorPage extends ResourceSelectorPage {

	SeffNewDiagramFileBlackboard blackboard;

	protected RepositorySelectorPage(SeffRepository seffRepository,
			SeffNewDiagramFileBlackboard blackboard) {
		super("Select repository", blackboard.getRepository());
		this.blackboard = blackboard;
		setTitle("Diagram repository");
		setDescription("Select the repository to be used for the diagram.");
		//blackboard.getRepository();
		if (!seffRepository.getResourceDemandingSeff().isEmpty()) {
			for (ResourceDemandingSEFF seff : seffRepository.getResourceDemandingSeff()) {
				if (seff.getSeffBehaviourStub() != null) {
					if (seff.getSeffBehaviourStub().getOperation() != null) {
						if (seff.getSeffBehaviourStub().eContainer() instanceof ComponentTypeImpl) {
							ComponentType component = (ComponentType) seff.getSeffBehaviourStub().eContainer();
							this.blackboard.setRepository((Repository) component.eContainer());
							break;
						}
					}
				}
			}
		}
	}

	public Repository getSelectedRepository() {
		return blackboard.getRepository();
	}

	@Override
	protected boolean validatePage() {
		if (getResolvedObject() == null) {
			setErrorMessage("No repository selected");
			return false;
		}

		if (getResolvedObject() instanceof Repository) {
			blackboard.setRepository((Repository) getResolvedObject());
		} else {
			setErrorMessage("Wrong resource type selected");
			return false;
		}

		setErrorMessage(null);
		return super.validatePage();
	}
}