package eu.qimpress.ide.editors.gmf.seff.part;

import java.util.List;
import java.util.Vector;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;

public class OperationSelectorPage extends WizardPage {

	private SeffRepository seffRepository;

	protected OperationSelectorPage(SeffRepository seffRepository, String pageName, SeffNewDiagramFileBlackboard blackboard) {
		super(pageName);
		this.seffRepository = seffRepository;
		setTitle("Diagram Operation");
		setDescription("Select the operation to be used for the diagram.");
		this.blackboard = blackboard;
		myCombo = null;
		myFoundOperations = new Vector<Operation>();
		myOperation = null;
		blackboard.addBlackboardListener(new BlackboardListener() {

			public void componentChanged() {
				findOperations();
				populateComboBox();
				myCombo.update();
			}

			public void filenameChanged() {
			}

			public void repositoryChanged() {
			}

		});
	}

	private Combo myCombo;
	private List<Operation> myFoundOperations;
	private Operation myOperation;
	private SeffNewDiagramFileBlackboard blackboard;

	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		Composite topLevel = new Composite(parent, SWT.NONE);
		topLevel.setLayout(new GridLayout());
		topLevel.setLayoutData(new GridData(GridData.VERTICAL_ALIGN_FILL | GridData.HORIZONTAL_ALIGN_FILL));
		topLevel.setFont(parent.getFont());
		setControl(topLevel);
		createPageContent(topLevel);
	}

	private void createPageContent(Composite parent) {
		Composite panel = new Composite(parent, SWT.NONE);
		panel.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout layout = new GridLayout();
		panel.setLayout(layout);

		Label label = new Label(panel, SWT.NONE);
		label.setText("Select Operation:");
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING));

		myCombo = new Combo(panel, SWT.DROP_DOWN | SWT.READ_ONLY);
		findOperations();
		populateComboBox();
		myCombo.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				setPageComplete(validatePage());
			}

		});
	}

	private void populateComboBox() {
		if (myCombo == null) {
			return;
		}

		myCombo.removeAll();
		for (Operation operation : myFoundOperations) {
			myCombo.add("Operation " + operation.getName() + " id: " + operation.getId());
		}
		if (myCombo.getVisibleItemCount() > 0) {
			myCombo.select(0);
		}
	}

	private void findOperations() {

		myFoundOperations.clear();

		ComponentType myComponent = blackboard.getComponent();
		if (myComponent == null) {
			return;

		}

		for (InterfacePort providedInterface : myComponent.getProvided()) {
			for (Operation operation : providedInterface.getInterfaceType().getSignatures()) {
				myFoundOperations.add(operation);
			}
		}
	}

	public Operation getOperation() {
		return myOperation;
	}

	protected boolean validatePage() {
		myOperation = null;
		if (myCombo.getSelectionIndex() == -1) {
			return false;
		}

		try {
			myOperation = myFoundOperations.get(myCombo.getSelectionIndex());
		} catch (ArrayIndexOutOfBoundsException e) {
			e.printStackTrace();
			return false;
		}

		for (ResourceDemandingSEFF seff : seffRepository.getResourceDemandingSeff()) {
			if (seff.getSeffBehaviourStub() == null) {
				setErrorMessage("The repository contains a SEFF with an empty stub. Please fix this first in the seff Model Editor.");
				return false;
			}
			if (seff.getSeffBehaviourStub().eContainer().equals(blackboard.getComponent())) {
				if (seff.getSeffBehaviourStub().getOperation().getId().equals(myOperation.getId())) {
					setErrorMessage("A SEFF is already specified for selected operation!");
					return false;
				}
			}
		}
		/*
		 * for (OperationBehaviour compOperation : blackboard.getComponent().getOperationBehaviour()) { if (compOperation instanceof SeffBehaviourStub) { if
		 * (compOperation.getOperation().getId().equals(myOperation.getId())) { setErrorMessage("A SEFF is already specified for selected operation!"); return
		 * false; } }
		 * 
		 * }
		 */

		blackboard.setOperation(myOperation);

		//propose a name in the diagram filename selection page
		String fileName = blackboard.getComponent().getName() + "." + myOperation.getName() + ".samm_seff_diagram";
		blackboard.setFilename(fileName);
		setErrorMessage(null);
		return true;
	}

}