package eu.qimpress.ide.editors.gmf.seff.part;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.impl.PrimitiveComponentImpl;
import eu.qimpress.seff.SeffRepository;

/**
 * This wizard page uses the regular resource selector page, but checks the type
 * of the resource selected by the user to be a Repository.
 */
class ComponentSelectorPage extends WizardPage {
	
	SeffNewDiagramFileBlackboard blackboard;
	
	protected EObject selectedModelElement;
	private TreeViewer modelViewer;


	protected ComponentSelectorPage(SeffRepository seffRepository,
			SeffNewDiagramFileBlackboard blackboard) {
		super("Select operation");
		this.blackboard = blackboard;
		setTitle("Diagram Operation");
		setDescription("Select the component to be used for the diagram.");

	}

	
	public void setModelElement(EObject modelElement) {
		selectedModelElement = modelElement;
		if (modelViewer != null) {
			if (selectedModelElement != null) {
				modelViewer.setInput(selectedModelElement.eResource());
				modelViewer.setSelection(new StructuredSelection(
						selectedModelElement));
			} else {
				modelViewer.setInput(null);
			}
			setPageComplete(validatePage());
		}
	}
	
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);

		Composite plate = new Composite(parent, SWT.NONE);
		plate.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout layout = new GridLayout();
		layout.marginWidth = 0;
		plate.setLayout(layout);
		setControl(plate);

		Label label = new Label(plate, SWT.NONE);
		//label.setText(getSelectionTitle());
		label.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING));

		modelViewer = new TreeViewer(plate, SWT.SINGLE | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.BORDER);
		GridData layoutData = new GridData(GridData.FILL_BOTH);
		layoutData.heightHint = 300;
		layoutData.widthHint = 300;
		modelViewer.getTree().setLayoutData(layoutData);
		modelViewer.setContentProvider(new AdapterFactoryContentProvider(
				SeffDiagramEditorPlugin.getInstance()
						.getItemProvidersAdapterFactory()));
		modelViewer.setLabelProvider(new AdapterFactoryLabelProvider(
				SeffDiagramEditorPlugin.getInstance()
						.getItemProvidersAdapterFactory()));
		blackboard.addBlackboardListener(new BlackboardListener() {

			public void componentChanged() {}
			public void filenameChanged() {}
			public void repositoryChanged() {
				if (blackboard.getRepository() != null) {
					modelViewer.setInput(blackboard.getRepository().eResource());
				}				
			}
			
		});
		if (blackboard.getRepository() != null) {
			modelViewer.setInput(blackboard.getRepository().eResource());
		}
		/*if (selectedModelElement != null) {
			modelViewer.setInput(selectedModelElement.eResource());
			modelViewer.setSelection(new StructuredSelection(
					selectedModelElement));
		}*/
		modelViewer
				.addSelectionChangedListener(new ISelectionChangedListener() {
					public void selectionChanged(SelectionChangedEvent event) {
						ComponentSelectorPage.this
								.updateSelection((IStructuredSelection) event
										.getSelection());
					}
				});

		setPageComplete(validatePage());
	}

	protected void updateSelection(IStructuredSelection selection) {
		selectedModelElement = null;
		if (selection.size() == 1) {
			Object selectedElement = selection.getFirstElement();
			if (selectedElement instanceof IWrapperItemProvider) {
				selectedElement = ((IWrapperItemProvider) selectedElement)
						.getValue();
			}
			if (selectedElement instanceof FeatureMap.Entry) {
				selectedElement = ((FeatureMap.Entry) selectedElement)
						.getValue();
			}
			if (selectedElement instanceof EObject) {
				selectedModelElement = (EObject) selectedElement;
			}
		}
		setPageComplete(validatePage());
	}

	protected boolean validatePage() {
		if (selectedModelElement == null) {
			setErrorMessage("No component selected");
			return false;
		}
		if (selectedModelElement instanceof PrimitiveComponentImpl) {
			setErrorMessage(null);
			blackboard.setComponent((ComponentType) selectedModelElement);
		} else {
			setErrorMessage("Wrong resource type selected");
			return false;
		}
		return true;
		/*
		if (getResolvedObject() == null) {
			setErrorMessage("No component selected");
			return false;
		}

		if (getResolvedObject() instanceof PrimitiveComponent) {
			blackboard.setComponent((ComponentType) getResolvedObject());
		} else {
			setErrorMessage("Wrong resource type selected");
			return false;
		}

		setErrorMessage(null);
		return super.validatePage();*/
	}
	

}