package eu.qimpress.ide.editors.gmf.seff.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

import eu.qimpress.ide.editors.gmf.seff.edit.parts.AbstractActionSuccessor_AbstractActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.AcquireActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.BranchAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.BranchActionBranchTransitionCompartment2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.BranchActionBranchTransitionCompartmentEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.BranchActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ExternalCallAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ExternalCallActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ForkAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ForkActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ForkActionForkedBehaviours2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ForkActionForkedBehavioursEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ForkedBehaviourBehaviourCompartmentEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ForkedBehaviourEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.InternalAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.InternalActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.LoopAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.LoopActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.LoopActionLoopCompartment2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.LoopActionLoopCompartmentEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ProbabilisticBranchTransitionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ReleaseActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingBehaviour2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingBehaviourBehaviourCompartment2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingBehaviourBehaviourCompartmentEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingBehaviourEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingSEFFEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.StartAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.StartActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.StopAction2EditPart;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.StopActionEditPart;
import eu.qimpress.ide.editors.gmf.seff.part.Messages;
import eu.qimpress.ide.editors.gmf.seff.part.SeffVisualIDRegistry;

/**
 * @generated
 */
public class SeffNavigatorContentProvider implements ICommonContentProvider {

	/**
	 * @generated
	 */
	private static final Object[] EMPTY_ARRAY = new Object[0];

	/**
	 * @generated
	 */
	private Viewer myViewer;

	/**
	 * @generated
	 */
	private AdapterFactoryEditingDomain myEditingDomain;

	/**
	 * @generated
	 */
	private WorkspaceSynchronizer myWorkspaceSynchronizer;

	/**
	 * @generated
	 */
	private Runnable myViewerRefreshRunnable;

	/**
	 * @generated
	 */
	public SeffNavigatorContentProvider() {
		TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
		myEditingDomain = (AdapterFactoryEditingDomain) editingDomain;
		myEditingDomain.setResourceToReadOnlyMap(new HashMap() {
			public Object get(Object key) {
				if (!containsKey(key)) {
					put(key, Boolean.TRUE);
				}
				return super.get(key);
			}
		});
		myViewerRefreshRunnable = new Runnable() {
			public void run() {
				if (myViewer != null) {
					myViewer.refresh();
				}
			}
		};
		myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate() {
			public void dispose() {
			}

			public boolean handleResourceChanged(final Resource resource) {
				for (Iterator it = myEditingDomain.getResourceSet().getResources().iterator(); it.hasNext();) {
					Resource nextResource = (Resource) it.next();
					nextResource.unload();
				}
				if (myViewer != null) {
					myViewer.getControl().getDisplay().asyncExec(myViewerRefreshRunnable);
				}
				return true;
			}

			public boolean handleResourceDeleted(Resource resource) {
				for (Iterator it = myEditingDomain.getResourceSet().getResources().iterator(); it.hasNext();) {
					Resource nextResource = (Resource) it.next();
					nextResource.unload();
				}
				if (myViewer != null) {
					myViewer.getControl().getDisplay().asyncExec(myViewerRefreshRunnable);
				}
				return true;
			}

			public boolean handleResourceMoved(Resource resource, final URI newURI) {
				for (Iterator it = myEditingDomain.getResourceSet().getResources().iterator(); it.hasNext();) {
					Resource nextResource = (Resource) it.next();
					nextResource.unload();
				}
				if (myViewer != null) {
					myViewer.getControl().getDisplay().asyncExec(myViewerRefreshRunnable);
				}
				return true;
			}
		});
	}

	/**
	 * @generated
	 */
	public void dispose() {
		myWorkspaceSynchronizer.dispose();
		myWorkspaceSynchronizer = null;
		myViewerRefreshRunnable = null;
		for (Iterator it = myEditingDomain.getResourceSet().getResources().iterator(); it.hasNext();) {
			Resource resource = (Resource) it.next();
			resource.unload();
		}
		((TransactionalEditingDomain) myEditingDomain).dispose();
		myEditingDomain = null;
	}

	/**
	 * @generated
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		myViewer = viewer;
	}

	/**
	 * @generated
	 */
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	/**
	 * @generated
	 */
	public void restoreState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void saveState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void init(ICommonContentExtensionSite aConfig) {
	}

	/**
	 * @generated
	 */
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IFile) {
			IFile file = (IFile) parentElement;
			URI fileURI = URI.createPlatformResourceURI(file.getFullPath().toString(), true);
			Resource resource = myEditingDomain.getResourceSet().getResource(fileURI, true);
			Collection result = new ArrayList();
			result.addAll(createNavigatorItems(selectViewsByType(resource.getContents(), ResourceDemandingSEFFEditPart.MODEL_ID), file, false));
			return result.toArray();
		}

		if (parentElement instanceof SeffNavigatorGroup) {
			SeffNavigatorGroup group = (SeffNavigatorGroup) parentElement;
			return group.getChildren();
		}

		if (parentElement instanceof SeffNavigatorItem) {
			SeffNavigatorItem navigatorItem = (SeffNavigatorItem) parentElement;
			if (navigatorItem.isLeaf() || !isOwnView(navigatorItem.getView())) {
				return EMPTY_ARRAY;
			}
			return getViewChildren(navigatorItem.getView(), parentElement);
		}

		return EMPTY_ARRAY;
	}

	/**
	 * @generated
	 */
	private Object[] getViewChildren(View view, Object parentElement) {
		switch (SeffVisualIDRegistry.getVisualID(view)) {

		case ResourceDemandingSEFFEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup links = new SeffNavigatorGroup(Messages.NavigatorGroupName_ResourceDemandingSEFF_1000_links,
					"icons/linksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StartActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ExternalCallActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(InternalActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StopActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AcquireActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ReleaseActionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getDiagramLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			links.addChildren(createNavigatorItems(connectedViews, links, false));
			if (!links.isEmpty()) {
				result.add(links);
			}
			return result.toArray();
		}

		case StartActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_2001_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_2001_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ExternalCallActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_2002_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_2002_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case InternalActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_2003_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_2003_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case BranchActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_2004_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_2004_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchActionBranchTransitionCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ProbabilisticBranchTransitionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case LoopActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_2005_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_2005_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopActionLoopCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ResourceDemandingBehaviour2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ForkActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_2006_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_2006_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkActionForkedBehaviours2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ForkedBehaviourEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case StopActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_2007_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_2007_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case AcquireActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_AcquireAction_2008_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_AcquireAction_2008_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ReleaseActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ReleaseAction_2009_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ReleaseAction_2009_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ProbabilisticBranchTransitionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			return result.toArray();
		}

		case ResourceDemandingBehaviourEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(StartAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(StopAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(InternalAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ExternalCallAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(LoopAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(BranchAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ForkAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			return result.toArray();
		}

		case StartAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_3003_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StartAction_3003_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case StopAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_3004_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_StopAction_3004_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case InternalAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_3005_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_InternalAction_3005_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ExternalCallAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_3006_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ExternalCallAction_3006_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case LoopAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_3007_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_LoopAction_3007_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopActionLoopCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ResourceDemandingBehaviour2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ResourceDemandingBehaviour2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(StartAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(StopAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(InternalAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ExternalCallAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(LoopAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ForkAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(BranchAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			return result.toArray();
		}

		case ForkAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_3009_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_ForkAction_3009_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkActionForkedBehavioursEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ForkedBehaviourEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ForkedBehaviourEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(StartAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(StopAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(InternalAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ExternalCallAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(LoopAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ForkAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(BranchAction2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			return result.toArray();
		}

		case BranchAction2EditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup incominglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_3011_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup outgoinglinks = new SeffNavigatorGroup(Messages.NavigatorGroupName_BranchAction_3011_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getChildrenByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchActionBranchTransitionCompartment2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews, SeffVisualIDRegistry.getType(ProbabilisticBranchTransitionEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement, false));
			connectedViews = getIncomingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews, incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews, outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID: {
			Collection result = new ArrayList();
			SeffNavigatorGroup target = new SeffNavigatorGroup(Messages.NavigatorGroupName_AbstractActionSuccessor_AbstractAction_4001_target,
					"icons/linkTargetNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			SeffNavigatorGroup source = new SeffNavigatorGroup(Messages.NavigatorGroupName_AbstractActionSuccessor_AbstractAction_4001_source,
					"icons/linkSourceNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StartActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ExternalCallActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(InternalActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StopActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AcquireActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ReleaseActionEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StartAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StopAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(InternalAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ExternalCallAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksTargetByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchAction2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StartActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ExternalCallActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(InternalActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StopActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(AcquireActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ReleaseActionEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StartAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(StopAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(InternalAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ExternalCallAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(LoopAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(ForkAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			connectedViews = getLinksSourceByType(Collections.singleton(view), SeffVisualIDRegistry.getType(BranchAction2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source, true));
			if (!target.isEmpty()) {
				result.add(target);
			}
			if (!source.isEmpty()) {
				result.add(source);
			}
			return result.toArray();
		}
		}
		return EMPTY_ARRAY;
	}

	/**
	 * @generated
	 */
	private Collection getLinksSourceByType(Collection edges, String type) {
		Collection result = new ArrayList();
		for (Iterator it = edges.iterator(); it.hasNext();) {
			Edge nextEdge = (Edge) it.next();
			View nextEdgeSource = nextEdge.getSource();
			if (type.equals(nextEdgeSource.getType()) && isOwnView(nextEdgeSource)) {
				result.add(nextEdgeSource);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection getLinksTargetByType(Collection edges, String type) {
		Collection result = new ArrayList();
		for (Iterator it = edges.iterator(); it.hasNext();) {
			Edge nextEdge = (Edge) it.next();
			View nextEdgeTarget = nextEdge.getTarget();
			if (type.equals(nextEdgeTarget.getType()) && isOwnView(nextEdgeTarget)) {
				result.add(nextEdgeTarget);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection getOutgoingLinksByType(Collection nodes, String type) {
		Collection result = new ArrayList();
		for (Iterator it = nodes.iterator(); it.hasNext();) {
			View nextNode = (View) it.next();
			result.addAll(selectViewsByType(nextNode.getSourceEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection getIncomingLinksByType(Collection nodes, String type) {
		Collection result = new ArrayList();
		for (Iterator it = nodes.iterator(); it.hasNext();) {
			View nextNode = (View) it.next();
			result.addAll(selectViewsByType(nextNode.getTargetEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection getChildrenByType(Collection nodes, String type) {
		Collection result = new ArrayList();
		for (Iterator it = nodes.iterator(); it.hasNext();) {
			View nextNode = (View) it.next();
			result.addAll(selectViewsByType(nextNode.getChildren(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection getDiagramLinksByType(Collection diagrams, String type) {
		Collection result = new ArrayList();
		for (Iterator it = diagrams.iterator(); it.hasNext();) {
			Diagram nextDiagram = (Diagram) it.next();
			result.addAll(selectViewsByType(nextDiagram.getEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection selectViewsByType(Collection views, String type) {
		Collection result = new ArrayList();
		for (Iterator it = views.iterator(); it.hasNext();) {
			View nextView = (View) it.next();
			if (type.equals(nextView.getType()) && isOwnView(nextView)) {
				result.add(nextView);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private boolean isOwnView(View view) {
		return ResourceDemandingSEFFEditPart.MODEL_ID.equals(SeffVisualIDRegistry.getModelID(view));
	}

	/**
	 * @generated
	 */
	private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
		Collection result = new ArrayList();
		for (Iterator it = views.iterator(); it.hasNext();) {
			result.add(new SeffNavigatorItem((View) it.next(), parent, isLeafs));
		}
		return result;
	}

	/**
	 * @generated
	 */
	public Object getParent(Object element) {
		if (element instanceof SeffAbstractNavigatorItem) {
			SeffAbstractNavigatorItem abstractNavigatorItem = (SeffAbstractNavigatorItem) element;
			return abstractNavigatorItem.getParent();
		}
		return null;
	}

	/**
	 * @generated
	 */
	public boolean hasChildren(Object element) {
		return element instanceof IFile || getChildren(element).length > 0;
	}

}
