package eu.qimpress.ide.editors.gmf.seff.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

import eu.qimpress.ide.editors.gmf.seff.part.SeffVisualIDRegistry;

/**
 * @generated
 */
public class SeffEditPartFactory implements EditPartFactory {

	/**
	 * @generated
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			switch (SeffVisualIDRegistry.getVisualID(view)) {

			case ResourceDemandingSEFFEditPart.VISUAL_ID:
				return new ResourceDemandingSEFFEditPart(view);

			case StartActionEditPart.VISUAL_ID:
				return new StartActionEditPart(view);

			case ExternalCallActionEditPart.VISUAL_ID:
				return new ExternalCallActionEditPart(view);

			case ExternalCallActionNameEditPart.VISUAL_ID:
				return new ExternalCallActionNameEditPart(view);

			case InternalActionEditPart.VISUAL_ID:
				return new InternalActionEditPart(view);

			case InternalActionNameEditPart.VISUAL_ID:
				return new InternalActionNameEditPart(view);

			case BranchActionEditPart.VISUAL_ID:
				return new BranchActionEditPart(view);

			case BranchActionNameEditPart.VISUAL_ID:
				return new BranchActionNameEditPart(view);

			case LoopActionEditPart.VISUAL_ID:
				return new LoopActionEditPart(view);

			case LoopActionNameEditPart.VISUAL_ID:
				return new LoopActionNameEditPart(view);

			case ForkActionEditPart.VISUAL_ID:
				return new ForkActionEditPart(view);

			case ForkActionNameEditPart.VISUAL_ID:
				return new ForkActionNameEditPart(view);

			case StopActionEditPart.VISUAL_ID:
				return new StopActionEditPart(view);

			case AcquireActionEditPart.VISUAL_ID:
				return new AcquireActionEditPart(view);

			case AcquireActionNameEditPart.VISUAL_ID:
				return new AcquireActionNameEditPart(view);

			case ReleaseActionEditPart.VISUAL_ID:
				return new ReleaseActionEditPart(view);

			case ReleaseActionNameEditPart.VISUAL_ID:
				return new ReleaseActionNameEditPart(view);

			case ProbabilisticBranchTransitionEditPart.VISUAL_ID:
				return new ProbabilisticBranchTransitionEditPart(view);

			case ResourceDemandingBehaviourEditPart.VISUAL_ID:
				return new ResourceDemandingBehaviourEditPart(view);

			case StartAction2EditPart.VISUAL_ID:
				return new StartAction2EditPart(view);

			case StopAction2EditPart.VISUAL_ID:
				return new StopAction2EditPart(view);

			case InternalAction2EditPart.VISUAL_ID:
				return new InternalAction2EditPart(view);

			case InternalActionName2EditPart.VISUAL_ID:
				return new InternalActionName2EditPart(view);

			case ExternalCallAction2EditPart.VISUAL_ID:
				return new ExternalCallAction2EditPart(view);

			case ExternalCallActionName2EditPart.VISUAL_ID:
				return new ExternalCallActionName2EditPart(view);

			case LoopAction2EditPart.VISUAL_ID:
				return new LoopAction2EditPart(view);

			case LoopActionName2EditPart.VISUAL_ID:
				return new LoopActionName2EditPart(view);

			case ResourceDemandingBehaviour2EditPart.VISUAL_ID:
				return new ResourceDemandingBehaviour2EditPart(view);

			case ForkAction2EditPart.VISUAL_ID:
				return new ForkAction2EditPart(view);

			case ForkActionName2EditPart.VISUAL_ID:
				return new ForkActionName2EditPart(view);

			case ForkedBehaviourEditPart.VISUAL_ID:
				return new ForkedBehaviourEditPart(view);

			case BranchAction2EditPart.VISUAL_ID:
				return new BranchAction2EditPart(view);

			case BranchActionName2EditPart.VISUAL_ID:
				return new BranchActionName2EditPart(view);

			case BranchActionBranchTransitionCompartmentEditPart.VISUAL_ID:
				return new BranchActionBranchTransitionCompartmentEditPart(view);

			case ResourceDemandingBehaviourBehaviourCompartmentEditPart.VISUAL_ID:
				return new ResourceDemandingBehaviourBehaviourCompartmentEditPart(view);

			case LoopActionLoopCompartmentEditPart.VISUAL_ID:
				return new LoopActionLoopCompartmentEditPart(view);

			case ResourceDemandingBehaviourBehaviourCompartment2EditPart.VISUAL_ID:
				return new ResourceDemandingBehaviourBehaviourCompartment2EditPart(view);

			case ForkActionForkedBehavioursEditPart.VISUAL_ID:
				return new ForkActionForkedBehavioursEditPart(view);

			case ForkedBehaviourBehaviourCompartmentEditPart.VISUAL_ID:
				return new ForkedBehaviourBehaviourCompartmentEditPart(view);

			case BranchActionBranchTransitionCompartment2EditPart.VISUAL_ID:
				return new BranchActionBranchTransitionCompartment2EditPart(view);

			case LoopActionLoopCompartment2EditPart.VISUAL_ID:
				return new LoopActionLoopCompartment2EditPart(view);

			case ForkActionForkedBehaviours2EditPart.VISUAL_ID:
				return new ForkActionForkedBehaviours2EditPart(view);

			case AbstractActionSuccessor_AbstractActionEditPart.VISUAL_ID:
				return new AbstractActionSuccessor_AbstractActionEditPart(view);

			}
		}
		return createUnrecognizedEditPart(context, model);
	}

	/**
	 * @generated
	 */
	private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
		// Handle creation of unrecognized child node EditParts here
		return null;
	}

	/**
	 * @generated
	 */
	public static CellEditorLocator getTextCellEditorLocator(ITextAwareEditPart source) {
		if (source.getFigure() instanceof WrappingLabel)
			return new TextCellEditorLocator((WrappingLabel) source.getFigure());
		else {
			return new LabelCellEditorLocator((Label) source.getFigure());
		}
	}

	/**
	 * @generated
	 */
	static private class TextCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private WrappingLabel wrapLabel;

		/**
		 * @generated
		 */
		public TextCellEditorLocator(WrappingLabel wrapLabel) {
			this.wrapLabel = wrapLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getWrapLabel() {
			return wrapLabel;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getWrapLabel().getTextBounds().getCopy();
			getWrapLabel().translateToAbsolute(rect);
			if (getWrapLabel().isTextWrapOn() && getWrapLabel().getText().length() > 0) {
				rect.setSize(new Dimension(text.computeSize(rect.width, SWT.DEFAULT)));
			} else {
				int avr = FigureUtilities.getFontMetrics(text.getFont()).getAverageCharWidth();
				rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT, SWT.DEFAULT)).expand(avr * 2, 0));
			}
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}

	/**
	 * @generated
	 */
	private static class LabelCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private Label label;

		/**
		 * @generated
		 */
		public LabelCellEditorLocator(Label label) {
			this.label = label;
		}

		/**
		 * @generated
		 */
		public Label getLabel() {
			return label;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getLabel().getTextBounds().getCopy();
			getLabel().translateToAbsolute(rect);
			int avr = FigureUtilities.getFontMetrics(text.getFont()).getAverageCharWidth();
			rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT, SWT.DEFAULT)).expand(avr * 2, 0));
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}
}
