package eu.qimpress.ide.editors.gmf.seff.edit.parts;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import eu.qimpress.ide.editors.gmf.seff.edit.policies.InternalActionItemSemanticEditPolicy;
import eu.qimpress.ide.editors.gmf.seff.part.SeffVisualIDRegistry;
import eu.qimpress.ide.editors.gmf.seff.providers.SeffElementTypes;

/**
 * @generated
 */
public class InternalActionEditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 2003;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public InternalActionEditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE, new InternalActionItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		LayoutEditPolicy lep = new LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		InternalActionFigure figure = new InternalActionFigure();
		return primaryShape = figure;
	}

	/**
	 * @generated
	 */
	public InternalActionFigure getPrimaryShape() {
		return (InternalActionFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof InternalActionNameEditPart) {
			((InternalActionNameEditPart) childEditPart).setLabel(getPrimaryShape().getFigureInternalActionFigureNameLabel());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof InternalActionNameEditPart) {
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(SeffVisualIDRegistry.getType(InternalActionNameEditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSource() {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnSourceAndTarget(IGraphicalEditPart targetEditPart) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (targetEditPart instanceof StartActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof ExternalCallActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof eu.qimpress.ide.editors.gmf.seff.edit.parts.InternalActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof BranchActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof LoopActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof ForkActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof StopActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof AcquireActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof ReleaseActionEditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof StartAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof StopAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof InternalAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof ExternalCallAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof LoopAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof ForkAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		if (targetEditPart instanceof BranchAction2EditPart) {
			types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMATypesForTarget(IElementType relationshipType) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StartAction_2001);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ExternalCallAction_2002);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.InternalAction_2003);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.BranchAction_2004);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.LoopAction_2005);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ForkAction_2006);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StopAction_2007);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.AcquireAction_2008);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ReleaseAction_2009);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StartAction_3003);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StopAction_3004);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.InternalAction_3005);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ExternalCallAction_3006);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.LoopAction_3007);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ForkAction_3009);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.BranchAction_3011);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMARelTypesOnTarget() {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		types.add(SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001);
		return types;
	}

	/**
	 * @generated
	 */
	public List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/getMATypesForSource(IElementType relationshipType) {
		List/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/types = new ArrayList/*<org.eclipse.gmf.runtime.emf.type.core.IElementType>*/();
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StartAction_2001);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ExternalCallAction_2002);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.InternalAction_2003);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.BranchAction_2004);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.LoopAction_2005);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ForkAction_2006);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StopAction_2007);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.AcquireAction_2008);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ReleaseAction_2009);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StartAction_3003);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.StopAction_3004);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.InternalAction_3005);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ExternalCallAction_3006);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.LoopAction_3007);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.ForkAction_3009);
		}
		if (relationshipType == SeffElementTypes.AbstractActionSuccessor_AbstractAction_4001) {
			types.add(SeffElementTypes.BranchAction_3011);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public class InternalActionFigure extends RoundedRectangle {

		/**
		 * @generated
		 */
		private WrappingLabel fFigureInternalActionFigureNameLabel;

		/**
		 * @generated
		 */
		public InternalActionFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			layoutThis.horizontalSpacing = 0;
			layoutThis.verticalSpacing = 0;
			layoutThis.marginWidth = 0;
			layoutThis.marginHeight = 0;
			this.setLayoutManager(layoutThis);

			this.setCornerDimensions(new Dimension(getMapMode().DPtoLP(8), getMapMode().DPtoLP(8)));
			this.setLineWidth(1);
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			WrappingLabel internalActionStereotypeLabelFigure0 = new WrappingLabel();
			internalActionStereotypeLabelFigure0.setText("<<InternalAction>>");
			internalActionStereotypeLabelFigure0.setBorder(new MarginBorder(getMapMode().DPtoLP(2), getMapMode().DPtoLP(0), getMapMode().DPtoLP(2),
					getMapMode().DPtoLP(0)));

			GridData constraintInternalActionStereotypeLabelFigure0 = new GridData();
			constraintInternalActionStereotypeLabelFigure0.verticalAlignment = GridData.CENTER;
			constraintInternalActionStereotypeLabelFigure0.horizontalAlignment = GridData.CENTER;
			constraintInternalActionStereotypeLabelFigure0.horizontalIndent = 0;
			constraintInternalActionStereotypeLabelFigure0.horizontalSpan = 1;
			constraintInternalActionStereotypeLabelFigure0.verticalSpan = 1;
			constraintInternalActionStereotypeLabelFigure0.grabExcessHorizontalSpace = false;
			constraintInternalActionStereotypeLabelFigure0.grabExcessVerticalSpace = false;
			this.add(internalActionStereotypeLabelFigure0, constraintInternalActionStereotypeLabelFigure0);

			fFigureInternalActionFigureNameLabel = new WrappingLabel();
			fFigureInternalActionFigureNameLabel.setText("<myName>");
			fFigureInternalActionFigureNameLabel.setBorder(new MarginBorder(getMapMode().DPtoLP(2), getMapMode().DPtoLP(0), getMapMode().DPtoLP(2),
					getMapMode().DPtoLP(0)));

			GridData constraintFFigureInternalActionFigureNameLabel = new GridData();
			constraintFFigureInternalActionFigureNameLabel.verticalAlignment = GridData.CENTER;
			constraintFFigureInternalActionFigureNameLabel.horizontalAlignment = GridData.CENTER;
			constraintFFigureInternalActionFigureNameLabel.horizontalIndent = 0;
			constraintFFigureInternalActionFigureNameLabel.horizontalSpan = 1;
			constraintFFigureInternalActionFigureNameLabel.verticalSpan = 1;
			constraintFFigureInternalActionFigureNameLabel.grabExcessHorizontalSpace = false;
			constraintFFigureInternalActionFigureNameLabel.grabExcessVerticalSpace = false;
			this.add(fFigureInternalActionFigureNameLabel, constraintFFigureInternalActionFigureNameLabel);

		}

		/**
		 * @generated
		 */
		private boolean myUseLocalCoordinates = false;

		/**
		 * @generated
		 */
		protected boolean useLocalCoordinates() {
			return myUseLocalCoordinates;
		}

		/**
		 * @generated
		 */
		protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
			myUseLocalCoordinates = useLocalCoordinates;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getFigureInternalActionFigureNameLabel() {
			return fFigureInternalActionFigureNameLabel;
		}

	}

}
