package eu.qimpress.ide.editors.gmf.seff.helper;

import java.util.List;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.util.FileUtil;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.seff.ResourceDemandingSEFF;
import eu.qimpress.seff.SeffRepository;
import eu.qimpress.seff.seffFactory;

public class SeffUtils {

	public static ResourceDemandingSEFF findReferencingSeff(OperationBehaviour stub) {
		IContainer parent = (IContainer) FileUtil.getIFile(stub.eResource().getURI()).getParent();
		List<IFile> seffFiles = FileUtil.getFile(parent,"samm_seff");
		if (seffFiles != null) {
			
			// load all seffResources into the resource set & look up for SeffBehaviours
			for (IFile seffFile : seffFiles) {
				Resource res = stub.eResource().getResourceSet().getResource(FileUtil.getURI(seffFile), true);
				try {
					if (res.getContents().get(0) instanceof SeffRepository)
						for (ResourceDemandingSEFF seff : ((SeffRepository) res.getContents()
								.get(0)).getResourceDemandingSeff())
							if (seff.getSeffBehaviourStub() != null
									&& seff.getSeffBehaviourStub().equals(stub))
								return seff;
				} catch (Throwable e) {
					continue;
				}
			}
		}
		return null;
	}

	public static SeffRepository getSeffRepository(final EObject ctx) {
		SeffRepository seffRepo;
		IContainer parent = (IContainer) FileUtil.getIFile(ctx.eResource().getURI()).getParent();
		if(FileUtil.getFile(parent,"samm_seff").size() > 0){
			IFile seff = FileUtil.getFile(parent,"samm_seff").get(0);
			
			Resource res = ctx.eResource().getResourceSet().getResource(FileUtil.getURI(seff), true);
			
			if(res.getContents().size() == 0){
				res.getContents().add(seffFactory.eINSTANCE.createSeffRepository());
			}
			seffRepo = (SeffRepository) res.getContents().get(0);
		}else {
			URI seffURI = ctx.eResource().getURI().trimFileExtension().appendFileExtension("samm_seff");
			Resource res = ctx.eResource().getResourceSet().createResource(seffURI);
			res.getContents().add(seffFactory.eINSTANCE.createSeffRepository());
			seffRepo = (SeffRepository) res.getContents().get(0);
		}	
		return seffRepo;
	}

}
