package eu.qimpress.ide.editors.gmf.seff.helper;

	import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import eu.qimpress.samm.annotation.provider.AnnotationItemProviderAdapterFactory;
import eu.qimpress.samm.behaviour.provider.BehaviourItemProviderAdapterFactory;
import eu.qimpress.samm.core.provider.CoreItemProviderAdapterFactory;
import eu.qimpress.samm.datatypes.provider.DatatypesItemProviderAdapterFactory;
import eu.qimpress.samm.deployment.allocation.provider.AllocationItemProviderAdapterFactory;
import eu.qimpress.samm.deployment.hardware.provider.HardwareItemProviderAdapterFactory;
import eu.qimpress.samm.deployment.targetenvironment.provider.TargetenvironmentItemProviderAdapterFactory;
import eu.qimpress.samm.qosannotation.provider.QosannotationItemProviderAdapterFactory;
import eu.qimpress.samm.staticstructure.provider.StaticstructureItemProviderAdapterFactory;
import eu.qimpress.samm.usagemodel.provider.UsagemodelItemProviderAdapterFactory;


/**
 * @author Snowball
 *
 */
public class SeffExternalCallActionSelectionDialog extends SelectEObjectDialog {
	
	private Object input;
	private AdapterFactoryContentProvider contentProvider;

	public SeffExternalCallActionSelectionDialog(Shell parent,
			Collection<Object> filterList, Object input) {
		super(parent);
		this.input = input;
		create();
		ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory();
		adapterFactory
				.addAdapterFactory(new ResourceItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new AnnotationItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new BehaviourItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new CoreItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new DatatypesItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new AllocationItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new HardwareItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new TargetenvironmentItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new QosannotationItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new StaticstructureItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new UsagemodelItemProviderAdapterFactory());
		adapterFactory
			.addAdapterFactory(new ReflectiveItemProviderAdapterFactory());

		/*contentProvider = new AdapterFactoryContentProvider(
				new FilteredItemsAdapterFactory(adapterFactory, filterList,
						additionalChildReferences));*/
		contentProvider = new AdapterFactoryContentProvider(
				new FilteredItemsAdapterFactory(adapterFactory));
		setViewerContentProvider(contentProvider);
		
		setViewerLabelProvider(new AdapterFactoryLabelProvider(
				new PalladioItemProviderAdapterFactory(adapterFactory)));
		setViewerInput(input);
		setInputDialogResourceName(filterList);
	}
	
	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.dialogs.selection.SelectEObjectDialog#setResourceName(java.util.Collection)
	 */
	@Override
	protected void setInputDialogResourceName(Collection<Object> filterList) {
		String system = "System";
		String repository = "Repository";
		String resourceRepository = "ResourceRepository";

		ArrayList<Object> list = new ArrayList<Object>();
		list.addAll(filterList);

		if (!list.isEmpty()) {
			for (Object object : list) {
				Class<?> clazz = (Class<?>) object;
				String name = clazz.getSimpleName();
				if (name.equals(system) || name.equals(repository)
						|| name.equals(resourceRepository))
					setResourceName(correctionResourceRepositoryName(name));
			}
		}
	}
	
	/** Correction the ResourceRepository to ResourceType */
	private String correctionResourceRepositoryName(String name){
		if (name.equals("ResourceRepository"))
			return "ResourceType";
		return name;
	}
	

	/* (non-Javadoc)
	 * @see de.uka.ipd.sdq.dialogs.selection.SelectEObjectDialog#addResourceToEditingDomain(org.eclipse.swt.widgets.Shell, java.lang.String)
	 */
	@Override
	protected void addModelToResourceSet(Shell shell, String uri) {
		ResourceSet resourceSet = getResourceSet(input);
		
		if (resourceSet != null) {
			URI model = URI.createURI(uri);
			try {
				resourceSet.getResource(model, true);
			} catch (Throwable t) {
				MessageDialog.openInformation(shell, "Resource Loader Error", t
						.getMessage());
			}
		}
	}
	
	/**
	 * Get a resource set from dialog input object
	 * 
	 * @param object -
	 *            dialog input object
	 */
	protected ResourceSet getResourceSet(Object object) {
		/** ResourceSet */
		if (object instanceof ResourceSet)
			return (ResourceSet) object;
		/** EObject */
		if (object instanceof EObject) {
			TransactionalEditingDomain editingDomain = TransactionUtil
					.getEditingDomain((EObject) object);
			if (editingDomain != null)
				return editingDomain.getResourceSet();
		}
		return null;
	}
	
	/**
	 * The method supplies the main knots of, in this dialogue the represented,
	 * tree
	 */
	public Object getViewerRootElement() {
		Object object = null;
		
		if (contentProvider != null){
			object = (contentProvider.getElements(input))[0];
		}
		
		return object;
	}
}
