/**
 * 
 */
package eu.qimpress.ide.editors.gmf.seff.helper;

import java.util.Collection;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.seff.ResourceDemandingSEFF;

/**
 * @author Snowball
 * Palladio Item Provider which renders Labels for elements of the Palladio Component Model
 *
 */
public class PalladioItemProvider extends ItemProviderDecorator implements
	IEditingDomainItemProvider,	
	IStructuredItemContentProvider,	
	ITreeItemContentProvider,	
	IItemLabelProvider,	
	IItemPropertySource,
	Adapter,
	CreateChildCommand.Helper {

	/**
	 * Default constructor
	 * @param adapterFactory Decorated adapter factory
	 */
	public PalladioItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderDecorator#getText(java.lang.Object)
	 * A label getter which is aware of the PCM
	 */
	@Override
	public String getText(Object object) {
		String result = "";
		if (object instanceof NamedEntity) {
			result = ((NamedEntity)object).getName();
		} else if (object instanceof ResourceDemandingSEFF){
			ResourceDemandingSEFF seff = (ResourceDemandingSEFF) object;
			result = "SEFF " + ((seff.getSeffBehaviourStub() == null) || (seff.getSeffBehaviourStub().getOperation() == null) ? "" : seff.getSeffBehaviourStub().getOperation().getName());
		} else {
			result = super.getText(object); 
		}
		if (object instanceof EObject)
		{
			result += " <"+((EObject)object).eClass().getName()+"> ";
		}
		if (object instanceof Identifier)
		{
			result += " [ID: " + ((Identifier)object).getId() + "]";
		}
		return result; 
	}

	public Notifier getTarget() {
		return ((Adapter)getDecoratedItemProvider()).getTarget();
	}

	public void setTarget(Notifier newTarget) {
		((Adapter)getDecoratedItemProvider()).setTarget(newTarget);
	}

	public String getCreateChildDescription(Object owner, Object feature,
			Object child, Collection<?> selection) {
		return ((CreateChildCommand.Helper)getDecoratedItemProvider()).getCreateChildDescription(owner, feature, child, selection);
	}

	public Object getCreateChildImage(Object owner, Object feature,
			Object child, Collection<?> selection) {
		return ((CreateChildCommand.Helper)getDecoratedItemProvider()).getCreateChildImage(owner, feature, child, selection);
	}

	public Collection<?> getCreateChildResult(Object child) {
		return ((CreateChildCommand.Helper)getDecoratedItemProvider()).getCreateChildResult(child);
	}

	public String getCreateChildText(Object owner, Object feature,
			Object child, Collection<?> selection) {
		if (selection.size() == 1) {
			if (owner instanceof EObject) {
				if (feature instanceof EReference) {
					String a = palladioConvention(((EReference)feature).getName());
					String b = ((EObject)child).eClass().getName();
					if (a.replaceAll(" ","").toLowerCase().equals(b.toLowerCase())) {
						return SeffHelperPlugin.INSTANCE.getString(
								"_UI_CreateChild_palladio_simple", 
								new Object[] {b}, 
								true);
					} else
						return SeffHelperPlugin.INSTANCE.getString(
							"_UI_CreateChild_palladio", 
							new Object[] {a,b}, 
							true);
				}
			}
		}
		return ((CreateChildCommand.Helper)getDecoratedItemProvider()).getCreateChildText(owner, feature, child, selection);
	}

	private String palladioConvention(String originalName) {
		if (originalName.indexOf("_") >= 0) {
			originalName = originalName.substring(0, originalName.indexOf("_"));
			if (originalName.length() >= 1) {
				String newOriginalName = Character.toUpperCase(originalName.charAt(0))+""; 
				for (int i=1; i < originalName.length(); i++) {
					if (Character.isUpperCase(originalName.charAt(i))) {
						newOriginalName += " ";
					}
					newOriginalName += originalName.charAt(i);
				}
				originalName = newOriginalName;
			}
		}
		return originalName;
	}

	public String getCreateChildToolTipText(Object owner, Object feature,
			Object child, Collection<?> selection) {
		return ((CreateChildCommand.Helper)getDecoratedItemProvider()).getCreateChildToolTipText(owner, feature, child, selection);
	}

	@Override
	public Command createCommand(Object object, EditingDomain domain,
			Class<? extends Command> commandClass,
			CommandParameter commandParameter) {
		if (commandClass == CreateChildCommand.class)
	    {
	      CommandParameter newChildParameter = (CommandParameter)commandParameter.getValue();
	      return new CreateChildCommand
	          (domain,
	           commandParameter.getEOwner(), 
	           newChildParameter.getEStructuralFeature(), 
	           newChildParameter.getValue(),
	           newChildParameter.getIndex(),
	           commandParameter.getCollection(),
	           this);      
	    }
		return super.createCommand(object, domain, commandClass, commandParameter);
	}
	
	
	
}
