package eu.qimpress.ide.editors.gmf.seff.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.ide.editors.gmf.common.diagram.custom.contributions.AbstractOpenDiagramAction;
import eu.qimpress.ide.editors.gmf.seff.edit.parts.ResourceDemandingSEFFEditPart;
import eu.qimpress.ide.editors.gmf.seff.part.SeffDiagramEditorPlugin;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.seff.ResourceDemandingSEFF;

public class OpenSeffDiagramAction extends AbstractOpenDiagramAction {
	
	public OpenSeffDiagramAction() {
	}

	public OpenSeffDiagramAction(ResourceDemandingSEFF seff) {
		diagramRoot = seff;
	}

	public String getFileExtension(){
		return "samm_seff_diagram";
	}

	public Diagram createDiagramView(EObject root){
		return ViewService.createDiagram( root,
				ResourceDemandingSEFFEditPart.MODEL_ID,
				SeffDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
	}

	@Override
	protected String getID(EObject diagramRoot) {
		return ((ResourceDemandingSEFF)diagramRoot).getSeffBehaviourStub().getId();
	}
	
	@Override
	public void run(IAction action) {
		if (diagramRoot == null) {
			MessageDialog.openError(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 
					"Model integrity problem", 
			"Could not locate a Seff Behaviour in the Seff models related to the selected Behaviour Stub\n\nNo diagram will be opened");
			return;
		}
		else if (diagramRoot instanceof ResourceDemandingSEFF == false) {
			// ignore action on other OperationBehaviours than SeffBehaviourStub
			return;
		}
		super.run(action);
	}

	@Override
	protected EObject getDiagramRoot(Object selectedElement) {
		EObject semanticElement = super.getDiagramRoot(selectedElement);
		if (semanticElement instanceof SeffBehaviourStub) {
			semanticElement = SeffUtils.findReferencingSeff((SeffBehaviourStub) semanticElement);
		}
		return semanticElement;
	}

}
