/**
 * 
 */
package eu.qimpress.ide.editors.gmf.seff.helper;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.ui.PlatformUI;

import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.seff.ResourceDemandingSEFF;


/**
 * @author Roman Andrej, Michael Hauck
 * 
 */
public class ExternalCallActionEditHelperAdvice extends
		AbstractEditHelperAdvice implements IEditHelperAdvice {

	/* (non-Javadoc)
	 * @see org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice#getAfterConfigureCommand(org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest)
	 */
	@Override
	protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
		EObject eObject = searchPrimitiveComponent(request.getElementToConfigure());
		InterfacePort interfacePort = null;
		
		// define the filter list
		ArrayList<Object> filterList = new ArrayList<Object>();
		filterList.add(PrimitiveComponent.class);
		filterList.add(InterfacePort.class);
		filterList.add(Interface.class);
		filterList.add(Operation.class);
		
		// create the dialog
		SeffExternalCallActionSelectionDialog dialog = new SeffExternalCallActionSelectionDialog(
				PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
				filterList, eObject);
		dialog.setProvidedService(Operation.class);
		dialog.open();
		if (dialog.getResult() == null)
			return new CanceledCommand();
		if (!(dialog.getResult() instanceof Operation))
			return new CanceledCommand();
		
		// set the signature for ExternalCallAction 
		Operation signature = (Operation) dialog.getResult();
		
		// set the required role for ExternalCallAction 
		if (dialog.getViewerRootElement() instanceof InterfacePort) {
			interfacePort = (InterfacePort) dialog.getRootOfResult();
		}

		// create and execute the ExternalCallActionConfigureCommand command
		return new ExternalCallActionConfigureCommand(request, signature,
				interfacePort);
	}

	private EObject searchPrimitiveComponent(EObject elementToConfigure) {
		EObject o = elementToConfigure;
		while (!(o instanceof ResourceDemandingSEFF)) {
			o = o.eContainer();		
		}
		ResourceDemandingSEFF behavior = (ResourceDemandingSEFF)o;
		o = behavior.getSeffBehaviourStub();
		while (!(o instanceof PrimitiveComponent)) {
			o = o.eContainer();
		}
		return o;
	}
}
