/**
 * 
 */
package eu.qimpress.ide.editors.gmf.seff.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.seff.seffPackage;

public class ExternalCallActionConfigureCommand extends ConfigureElementCommand {

	private ConfigureRequest request = null;
	private Operation operation = null;
	private InterfacePort interfacePort = null;
	
	public ExternalCallActionConfigureCommand(ConfigureRequest request,
			Operation operation, InterfacePort interfacePort) {
		super(request);
		this.request = request;
		this.operation = operation;
		this.interfacePort = interfacePort;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand#doExecuteWithResult(org.eclipse.core.runtime.IProgressMonitor, org.eclipse.core.runtime.IAdaptable)
	 */
	@Override
	protected CommandResult doExecuteWithResult(IProgressMonitor monitor,
			IAdaptable info) throws ExecutionException {
		CommandResult commandResult = setOperationExternalCallAction(monitor,
				info);
		if (!isOK(commandResult)) {
			return CommandResult
					.newErrorCommandResult("Set Signature for the ExternalCallAction failed!");
		}
		commandResult = setPortEntryLevelSystemCall(monitor, info);
		if (!isOK(commandResult)) {
			return CommandResult
					.newErrorCommandResult("Set ProvidedRole for the ExternalCallAction failed!");
		}
		return CommandResult.newOKCommandResult();
	}
	
	
	private CommandResult setOperationExternalCallAction(
			IProgressMonitor monitor, IAdaptable info)
			throws ExecutionException {

		ICommand cmd = new SetValueCommand(new SetRequest(request
				.getElementToConfigure(), seffPackage.eINSTANCE
				.getExternalCallAction_CalledService(),
				operation));

		cmd.execute(monitor, info);

		return cmd.getCommandResult();
	}
	
	private CommandResult setPortEntryLevelSystemCall(
			IProgressMonitor monitor, IAdaptable info)
			throws ExecutionException {

		ICommand cmd = new SetValueCommand(new SetRequest(request
				.getElementToConfigure(), seffPackage.eINSTANCE
				.getExternalCallAction_CalledInterfacePort(), interfacePort));

		cmd.execute(monitor, info);

		return cmd.getCommandResult();
	}
}
